package cn.zzq0324.radish.web.configuration;

import cn.zzq0324.radish.common.spring.SpringContextHolder;
import cn.zzq0324.radish.web.annotation.Interceptor;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

/**
 * 框架级别配置
 *
 * @author: zzq0324
 * @since : 1.0.0
 */
@Slf4j
@Configuration
@Import(SpringContextHolder.class)
public class RadishWebAutoConfiguration implements WebMvcConfigurer {

  // 公共过滤参数
  public static final List<String> COMMON_EXCLUDE_PATHS = Arrays.asList("/actuator/**", "/swagger-ui/index.html",
      "/swagger-ui.html");

  @Autowired
  private Optional<List<HandlerInterceptor>> optionalList;

  @Override
  public void addInterceptors(InterceptorRegistry registry) {
    if (optionalList.get() == null) {
      return;
    }

    optionalList.get().forEach(interceptor -> {
      InterceptorRegistration registration = registry.addInterceptor(interceptor);
      // 过滤公共参数
      registration.excludePathPatterns(COMMON_EXCLUDE_PATHS);

      // 查找类上是否注解了@Interceptor，有注解的话除了公共的过滤路径，还需要设置个性的部分
      Interceptor interceptorAnnotation = AnnotationUtils.findAnnotation(interceptor.getClass(), Interceptor.class);
      if (interceptorAnnotation != null) {
        addExcludePathsFromAnnotation(interceptorAnnotation, registration);
        addIncludePathsFromAnnotation(interceptorAnnotation, registration);
      }

      log.info("interceptor: {} added to InterceptorRegistry successfully", interceptor.getClass().getName());
    });
  }

  private void addExcludePathsFromAnnotation(Interceptor interceptorAnnotation, InterceptorRegistration registration) {
    if (interceptorAnnotation.excludePaths() != null && interceptorAnnotation.excludePaths().length > 0) {
      registration.excludePathPatterns(interceptorAnnotation.excludePaths());
    }
  }

  private void addIncludePathsFromAnnotation(Interceptor interceptorAnnotation, InterceptorRegistration registration) {
    if (interceptorAnnotation.includePaths() != null && interceptorAnnotation.includePaths().length > 0) {
      registration.addPathPatterns(interceptorAnnotation.includePaths());
    }
  }
}
