package cn.zzq0324.radish.components.trade.model.callback;

import java.math.BigDecimal;
import java.util.Date;
import lombok.Getter;
import lombok.Setter;

/**
 * 交易回调数据
 *
 * @author: zzq0324
 * @since : 1.0.0
 */
@Getter
@Setter
public class PayCallbackData {

  /**
   * 交易渠道
   */
  private String channel;

  /**
   * appId
   */
  private String appId;

  /**
   * 交易流水号
   */
  private String tradeNo;

  /**
   * 三方交易流水号
   */
  private String thirdTradeNo;

  /**
   * 交易金额
   */
  private BigDecimal amount;

  /**
   * 交易状态
   */
  private int tradeStatus;

  /**
   * 交易时间
   */
  private Date tradeTime;

  /**
   * 付款人id
   */
  private String payerId;

  /**
   * 原始数据
   */
  private String originalData;
}
