package cn.zzq0324.radish.components.trade.extension.pay;

import cn.zzq0324.radish.components.trade.model.callback.PayCallbackData;
import cn.zzq0324.radish.components.trade.model.callback.RefundCallbackData;
import cn.zzq0324.radish.components.trade.model.placeorder.PlaceOrderRequest;
import cn.zzq0324.radish.components.trade.model.request.RefundRequest;
import cn.zzq0324.radish.components.trade.model.request.RefundResult;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

/**
 * 支付通道
 *
 * @author: zzq0324
 * @since : 1.0.0
 */
public interface PayChannel {

  String CHANNEL_WECHAT = "wechat";
  String CHANNEL_ALIPAY = "alipay";

  /**
   * 下单，返回下单后的信息
   */
  Map<String, Object> placeOrder(PlaceOrderRequest request);

  /**
   * 退款
   */
  RefundResult refund(RefundRequest request);

  /**
   * 解析支付回调数据
   */
  PayCallbackData parsePayCallback(HttpServletRequest request);

  /**
   * 解析退款回调数据
   */
  RefundCallbackData parseRefundCallback(HttpServletRequest request);
}
