package cn.zzq0324.radish.components.trade.controller;

import javax.servlet.http.HttpServletRequest;
import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 支付控制器
 *
 * @author: zzq0324
 * @since : 1.0.0
 */
@Slf4j
@RequestMapping(value = "/v1/trade")
@RestController
public class RadishTradeController {

  /**
   * 支付回调
   *
   * @param channel 通道，例如：微信、支付宝
   * @param appId   通道下的应用id或商户id
   * @return 返回结果由对应的扩展点返回
   */
  @Transactional
  @RequestMapping(value = "/callback/pay/{channel}/{appId}")
  public Object payCallback(@PathVariable("channel") String channel, @PathVariable("appId") int appId,
      HttpServletRequest request) {

    return null;
  }

  /**
   * 退款回调
   *
   * @param channel 通道，例如：微信、支付宝
   * @param appId   通道下的应用id或商户id
   * @return 返回结果由对应的扩展点返回
   */
  @Transactional
  @RequestMapping(value = "/callback/refund/{channel}/{appId}")
  public Object refundCallback(@PathVariable("channel") String channel, @PathVariable("appId") int appId,
      HttpServletRequest request) {

    return null;
  }
}
