package cn.zzq0324.radish.components.trade.config;

import java.util.Map;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

/**
 * 交易配置
 *
 * @author: zzq0324
 * @since : 1.0.0
 */
@Configuration
@ConfigurationProperties(prefix = "radish.trade")
public class TradeProperties {

  /**
   * 应用中实际会支持多个渠道、同个渠道也可能有多个收款账号，apps底下的key为appId，appId底下根据不同渠道的固定参数进行设置，会合并提交
   */
  private Map<String, Map<String, String>> apps;

  /**
   * 通知url前缀，例如: https://www.xxx.com
   */
  private String notifyUrlPrefix;
}