/*
 * Decompiled with CFR 0.152.
 */
package cn.zzq0324.radish.components.http.util;

import cn.zzq0324.radish.common.code.CommonStatusCode;
import cn.zzq0324.radish.common.code.StatusCode;
import cn.zzq0324.radish.common.exception.BusinessException;
import cn.zzq0324.radish.common.util.JsonUtils;
import cn.zzq0324.radish.components.http.constant.HttpMethodType;
import cn.zzq0324.radish.components.http.constant.MediaTypes;
import java.util.Map;
import java.util.Objects;
import okhttp3.FormBody;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okio.Buffer;
import okio.BufferedSink;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class RequestUtils {
    public static boolean containsHeaderValue(Request request, String headerName, String headerValue) {
        String value = request.header(headerName);
        return Objects.equals(value, headerValue);
    }

    public static boolean containsHeader(Request request, String headerName) {
        String value = request.header(headerName);
        return StringUtils.hasLength((String)value);
    }

    public static Request buildRequest(String url, HttpMethodType methodType, Object requestData) {
        switch (methodType) {
            case GET: {
                return RequestUtils.buildGetRequest(url, requestData);
            }
            case POST_FORM: {
                return RequestUtils.buildPostRequest(url, requestData);
            }
            case POST_APPLICATION: {
                return RequestUtils.buildPostEntityRequest(url, requestData);
            }
        }
        throw new BusinessException((StatusCode)CommonStatusCode.METHOD_NOT_SUPPORT);
    }

    public static Request buildGetRequest(String url) {
        return RequestUtils.buildGetRequest(url, null);
    }

    public static Request buildGetRequest(String url, Object requestData) {
        HttpUrl.Builder httpBuilder = HttpUrl.parse((String)url).newBuilder();
        Map<String, Object> requestDataMap = RequestUtils.objectToMap(requestData);
        if (!CollectionUtils.isEmpty(requestDataMap)) {
            requestDataMap.keySet().forEach(key -> {
                Object value = requestDataMap.get(key);
                httpBuilder.addQueryParameter(key, value == null ? null : value.toString());
            });
        }
        return new Request.Builder().url(httpBuilder.build()).build();
    }

    public static Request buildPostEntityRequest(String url) {
        return RequestUtils.buildPostEntityRequest(url, null);
    }

    public static Request buildPostEntityRequest(String url, Object requestData) {
        RequestBody requestBody = RequestBody.create((String)JsonUtils.toJson((Object)requestData), (MediaType)MediaTypes.APPLICATION_JSON);
        return new Request.Builder().url(url).post(requestBody).build();
    }

    public Request buildPostRequest(String url) {
        return RequestUtils.buildPostRequest(url, null);
    }

    public static Request buildPostRequest(String url, Object requestData) {
        FormBody.Builder formBuilder = new FormBody.Builder();
        Map<String, Object> requestDataMap = RequestUtils.objectToMap(requestData);
        if (!CollectionUtils.isEmpty(requestDataMap)) {
            requestDataMap.keySet().forEach(key -> {
                Object value = requestDataMap.get(key);
                formBuilder.add(key, value == null ? null : value.toString());
            });
        }
        FormBody requestForm = formBuilder.build();
        return new Request.Builder().url(url).post((RequestBody)requestForm).build();
    }

    private static Map<String, Object> objectToMap(Object data) {
        if (data == null) {
            return null;
        }
        if (data instanceof Map) {
            return (Map)data;
        }
        return (Map)JsonUtils.objectMapper().convertValue(data, Map.class);
    }

    public static String getUrl(Request request) {
        return request.url().url().toString();
    }

    public static String getBodyAsString(Request request) {
        if (request.body() == null) {
            return null;
        }
        Throwable throwable = null;
        try (Buffer buffer = new Buffer();){
            request.body().writeTo((BufferedSink)buffer);
            String string = buffer.readUtf8();
            return string;
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }
}

