/*
 * Decompiled with CFR 0.152.
 */
package cn.zzq0324.radish.components.http.configuration;

import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OkHttpClientFactory {
    private static final Logger log = LoggerFactory.getLogger(OkHttpClientFactory.class);

    public OkHttpClient.Builder createBuilder(boolean disableSslValidation) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        if (disableSslValidation) {
            try {
                DisableValidationTrustManager disabledTrustManager = new DisableValidationTrustManager();
                TrustManager[] trustManagers = new TrustManager[]{disabledTrustManager};
                SSLContext sslContext = SSLContext.getInstance("SSL");
                sslContext.init(null, trustManagers, new SecureRandom());
                SSLSocketFactory disabledSSLSocketFactory = sslContext.getSocketFactory();
                builder.sslSocketFactory(disabledSSLSocketFactory, (X509TrustManager)disabledTrustManager);
                builder.hostnameVerifier((HostnameVerifier)new TrustAllHostnames());
            }
            catch (NoSuchAlgorithmException e) {
                log.warn("Error setting SSLSocketFactory in OKHttpClient", (Throwable)e);
            }
            catch (KeyManagementException e) {
                log.warn("Error setting SSLSocketFactory in OKHttpClient", (Throwable)e);
            }
        }
        return builder;
    }

    private static class TrustAllHostnames
    implements HostnameVerifier {
        private TrustAllHostnames() {
        }

        @Override
        public boolean verify(String s, SSLSession sslSession) {
            return true;
        }
    }

    private static class DisableValidationTrustManager
    implements X509TrustManager {
        private DisableValidationTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

