package cn.zzq0324.radish.extension.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 扩展点声明
 *
 * @author zzq0324
 * @since : 1.0.0
 */
@Inherited
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.TYPE})
public @interface SPI {

  /**
   * 扩展点描述，非必填
   */
  String desc() default "";

  /**
   * 场景ID是否允许重复，默认不允许
   */
  boolean scenarioRepeatable() default false;
}