package cn.zzq0324.radish.extension.annotation;

import cn.zzq0324.radish.extension.ExtensionConstant;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Component;

/**
 * 扩展点的具体实现
 *
 * @author  zzq0324
 * @since : 1.0.0
 */
@Inherited
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.TYPE})
@Component
public @interface Extension {

  /**
   * 业务线，例如：淘宝、天猫、聚划算
   */
  String business() default ExtensionConstant.DEFAULT_BUSINESS;

  /**
   * 模块或者用例，例如：支付
   */
  String useCase() default ExtensionConstant.DEFAULT_USE_CASE;

  /**
   * 场景，例如兑换券支付、移动支付、线下支付等
   */
  String scenario() default ExtensionConstant.DEFAULT_SCENARIO;

  /**
   * 扩展点顺序，获取列表的时候排序使用。参照Spring的order，越小排序越靠前
   */
  int order() default Ordered.LOWEST_PRECEDENCE;

  /**
   * 扩展节点概述
   */
  String desc() default "";
}

