/*
 * Decompiled with CFR 0.152.
 */
package cn.zzq0324.radish.extension;

import cn.zzq0324.radish.common.spring.SpringContextHolder;
import cn.zzq0324.radish.extension.BusinessScenario;
import cn.zzq0324.radish.extension.annotation.Extension;
import cn.zzq0324.radish.extension.annotation.SPI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class ExtensionLoader<T> {
    private static final Logger log = LoggerFactory.getLogger(ExtensionLoader.class);
    private static final ConcurrentMap<Class<?>, ExtensionLoader<?>> EXTENSION_LOADERS = new ConcurrentHashMap();
    private final Map<BusinessScenario, List<T>> extensionInfoMap = new LinkedHashMap<BusinessScenario, List<T>>();

    private ExtensionLoader(Class<T> type) {
        if (!ExtensionLoader.withSPIAnnotation(type)) {
            throw new IllegalArgumentException("Type (" + type + ") should be annotated with @SPI !");
        }
        Map beanMap = SpringContextHolder.getApplicationContext().getBeansOfType(type);
        if (CollectionUtils.isEmpty((Map)beanMap)) {
            log.warn("empty extension with type [{}]", (Object)type.getName());
            return;
        }
        List<T> orderedExtensionList = this.sort(beanMap);
        orderedExtensionList.stream().forEach(extensionInstance -> {
            Extension extension = this.getExtensionAnnotation(extensionInstance);
            BusinessScenario scenario = BusinessScenario.of(extension.business(), extension.useCase(), extension.scenario());
            this.addExtensionToMap(scenario, extensionInstance);
        });
        this.printExtensionList(type);
        this.checkRepeatable(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> ExtensionLoader<T> getExtensionLoader(Class<T> type) {
        if (type == null) {
            throw new IllegalArgumentException("Extension type == null");
        }
        ExtensionLoader loader = (ExtensionLoader)EXTENSION_LOADERS.get(type);
        if (loader == null) {
            Class<T> clazz = type;
            synchronized (clazz) {
                loader = EXTENSION_LOADERS.computeIfAbsent(type, spiType -> new ExtensionLoader(spiType));
            }
        }
        return loader;
    }

    public static <T> T getExtension(Class<T> type, BusinessScenario scenario) {
        return ExtensionLoader.getExtension(type, scenario, false);
    }

    public static <T> T getExtension(Class<T> type, String scenario) {
        BusinessScenario businessScenario = BusinessScenario.of("defaultBusiness", "defaultUseCase", scenario);
        return ExtensionLoader.getExtension(type, businessScenario, false);
    }

    public static <T> T getExtension(Class<T> type, BusinessScenario scenario, boolean fallback) {
        List<T> extList = ExtensionLoader.getExtensionList(type, scenario, fallback);
        if (CollectionUtils.isEmpty(extList)) {
            return null;
        }
        return extList.get(0);
    }

    public static <T> List<T> getExtensionList(Class<T> type, BusinessScenario scenario) {
        return ExtensionLoader.getExtensionList(type, scenario, false);
    }

    public static <T> List<T> getExtensionList(Class<T> type, BusinessScenario scenario, boolean failOver) {
        List<T> extensionList = ExtensionLoader.getExtensionLoader(type).extensionInfoMap.get(scenario);
        if (!CollectionUtils.isEmpty(extensionList)) {
            return extensionList;
        }
        if (!failOver) {
            return null;
        }
        return ExtensionLoader.getFailOverExtensionList(type, scenario);
    }

    public static <T> List<T> getFailOverExtensionList(Class<T> type, BusinessScenario scenario) {
        List<T> extensionList = ExtensionLoader.getExtensionLoader(type).extensionInfoMap.get(scenario = BusinessScenario.of(scenario.getBusiness(), scenario.getUseCase()));
        if (!CollectionUtils.isEmpty(extensionList)) {
            return extensionList;
        }
        extensionList = ExtensionLoader.getExtensionLoader(type).extensionInfoMap.get(scenario = BusinessScenario.of(scenario.getBusiness()));
        if (!CollectionUtils.isEmpty(extensionList)) {
            return extensionList;
        }
        scenario = BusinessScenario.of();
        return ExtensionLoader.getExtensionLoader(type).extensionInfoMap.get(scenario);
    }

    public Map<BusinessScenario, List<T>> getExtensionInfoMap() {
        return this.extensionInfoMap;
    }

    private void checkRepeatable(Class<?> type) {
        SPI spi = type.getAnnotation(SPI.class);
        if (spi.scenarioRepeatable()) {
            return;
        }
        this.extensionInfoMap.values().forEach(extList -> Assert.isTrue((extList.size() <= 1 ? 1 : 0) != 0, (String)"scenario cannot repeat!"));
    }

    private void addExtensionToMap(BusinessScenario scenario, T extensionInstance) {
        List extensionList = this.extensionInfoMap.computeIfAbsent(scenario, group -> new ArrayList());
        extensionList.add(extensionInstance);
    }

    private void printExtensionList(Class<T> type) {
        log.info("|\u2500\u2500  {}", (Object)type.getName());
        this.extensionInfoMap.keySet().forEach(scenario -> {
            log.info("|    |\u2500\u2500 {}", scenario);
            this.extensionInfoMap.get(scenario).forEach(instance -> log.info("|    |    |\u2500\u2500 {}", (Object)instance.getClass().getName()));
        });
    }

    private <T> List<T> sort(Map<String, T> beanMap) {
        List orderedExtensionList = beanMap.values().stream().collect(Collectors.toList());
        Collections.sort(orderedExtensionList, (o1, o2) -> {
            Extension extension1 = this.getExtensionAnnotation(o1);
            Extension extension2 = this.getExtensionAnnotation(o2);
            return extension1.order() - extension2.order();
        });
        return orderedExtensionList;
    }

    private <T> Extension getExtensionAnnotation(T extensionInstance) {
        Class targetClass = AopUtils.getTargetClass(extensionInstance);
        if (!targetClass.isAnnotationPresent(Extension.class)) {
            throw new RuntimeException(targetClass.getName() + " not annotated with @Extension.");
        }
        return targetClass.getAnnotation(Extension.class);
    }

    private static <T> boolean withSPIAnnotation(Class<T> type) {
        return type.isAnnotationPresent(SPI.class);
    }
}

