/*
 * Decompiled with CFR 0.152.
 */
package cn.zzq0324.radish.extension;

import java.util.Objects;
import org.springframework.util.Assert;
import org.springframework.util.ConcurrentLruCache;
import org.springframework.util.StringUtils;

public class BusinessScenario {
    public static final String SPLIT = "#";
    public static final String IDENTIFY_TPL = "%s#%s#%s";
    private static ConcurrentLruCache<String, BusinessScenario> CACHE = new ConcurrentLruCache(1024, scenarioStr -> {
        String[] arr = StringUtils.delimitedListToStringArray((String)scenarioStr, (String)SPLIT);
        return new BusinessScenario(arr[0], arr[1], arr[2]);
    });
    private String business;
    private String useCase;
    private String scenario;

    private BusinessScenario(String business, String useCase, String scenario) {
        this.business = business;
        this.useCase = useCase;
        this.scenario = scenario;
    }

    public static BusinessScenario of(String business, String useCase, String scenario) {
        Assert.doesNotContain((String)business, (String)SPLIT, (String)"business must not contain #");
        Assert.doesNotContain((String)useCase, (String)SPLIT, (String)"useCase must not contain #");
        Assert.doesNotContain((String)scenario, (String)SPLIT, (String)"scenario must not contain #");
        return (BusinessScenario)CACHE.get((Object)BusinessScenario.getScenarioId(business, useCase, scenario));
    }

    public static BusinessScenario of(String business, String useCase) {
        return BusinessScenario.of(business, useCase, "defaultScenario");
    }

    public static BusinessScenario of(String business) {
        return BusinessScenario.of(business, "defaultUseCase", "defaultScenario");
    }

    public static BusinessScenario of() {
        return BusinessScenario.of("defaultBusiness", "defaultUseCase", "defaultScenario");
    }

    public static String getScenarioId(String business, String useCase, String scenario) {
        return String.format(IDENTIFY_TPL, business, useCase, scenario);
    }

    public String toString() {
        return String.format(IDENTIFY_TPL, this.business, this.useCase, this.scenario);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BusinessScenario that = (BusinessScenario)o;
        return this.business.equals(that.business) && this.useCase.equals(that.useCase) && this.scenario.equals(that.scenario);
    }

    public int hashCode() {
        return Objects.hash(this.business, this.useCase, this.scenario);
    }

    public String getBusiness() {
        return this.business;
    }

    public String getUseCase() {
        return this.useCase;
    }

    public String getScenario() {
        return this.scenario;
    }
}

