/*
 * Decompiled with CFR 0.152.
 */
package cn.zzq0324.radish.data.mybatis.handler;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.MappedJdbcTypes;
import org.apache.ibatis.type.MappedTypes;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
@MappedTypes(value={LocalDate.class})
@MappedJdbcTypes(value={JdbcType.DATE}, includeNullJdbcType=true)
public class LocalDateTypeHandler
extends BaseTypeHandler<LocalDate> {
    public static final String NORM_DATE_PATTERN = "yyyy-MM-dd";
    private final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");

    public void setNonNullParameter(PreparedStatement ps, int i, LocalDate parameter, JdbcType jdbcType) throws SQLException {
        if (parameter != null) {
            ps.setString(i, this.dateTimeFormatter.format(parameter));
        }
    }

    public LocalDate getNullableResult(ResultSet rs, String columnName) throws SQLException {
        String target = rs.getString(columnName);
        if (!StringUtils.hasText((String)target)) {
            return null;
        }
        return LocalDate.parse(target, this.dateTimeFormatter);
    }

    public LocalDate getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        String target = rs.getString(columnIndex);
        if (!StringUtils.hasText((String)target)) {
            return null;
        }
        return LocalDate.parse(target, this.dateTimeFormatter);
    }

    public LocalDate getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        String target = cs.getString(columnIndex);
        if (!StringUtils.hasText((String)target)) {
            return null;
        }
        return LocalDate.parse(target, this.dateTimeFormatter);
    }
}

