/*
 * Decompiled with CFR 0.152.
 */
package cn.zzq0324.radish.data.mybatis.handler;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.MappedJdbcTypes;
import org.apache.ibatis.type.MappedTypes;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
@MappedTypes(value={LocalDateTime.class})
@MappedJdbcTypes(value={JdbcType.DATE}, includeNullJdbcType=true)
public class LocalDateTimeTypeHandler
extends BaseTypeHandler<LocalDateTime> {
    public static final String NORM_DATETIME_PATTERN = "yyyy-MM-dd HH:mm:ss";
    public static final String NORM_DATETIME_MS_PATTERN = "yyyy-MM-dd HH:mm:ss.SSS";
    private final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private final DateTimeFormatter dateTimeMsFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");

    public void setNonNullParameter(PreparedStatement ps, int i, LocalDateTime parameter, JdbcType jdbcType) throws SQLException {
        if (parameter != null) {
            ps.setString(i, this.dateTimeFormatter.format(parameter));
        }
    }

    public LocalDateTime getNullableResult(ResultSet rs, String columnName) throws SQLException {
        String target = rs.getString(columnName);
        if (!StringUtils.hasText((String)target)) {
            return null;
        }
        if (target.contains(".")) {
            return LocalDateTime.parse(target, this.dateTimeMsFormatter);
        }
        return LocalDateTime.parse(target, this.dateTimeFormatter);
    }

    public LocalDateTime getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        String target = rs.getString(columnIndex);
        if (!StringUtils.hasText((String)target)) {
            return null;
        }
        if (target.contains(".")) {
            return LocalDateTime.parse(target, this.dateTimeMsFormatter);
        }
        return LocalDateTime.parse(target, this.dateTimeFormatter);
    }

    public LocalDateTime getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        String target = cs.getString(columnIndex);
        if (!StringUtils.hasText((String)target)) {
            return null;
        }
        if (target.contains(".")) {
            return LocalDateTime.parse(target, this.dateTimeMsFormatter);
        }
        return LocalDateTime.parse(target, this.dateTimeFormatter);
    }
}

