/*
 * Decompiled with CFR 0.152.
 */
package cn.zzq0324.radish.data.mybatis.configuration;

import cn.zzq0324.radish.context.RequestContext;
import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.PaginationInnerInterceptor;
import java.time.LocalDateTime;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.reflection.MetaObject;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class MybatisPlusConfiguration
implements MetaObjectHandler {
    public static final String CREATOR = "creator";
    public static final String CREATE_TIME = "createTime";
    public static final String MODIFIER = "modifier";
    public static final String UPDATE_TIME = "updateTime";

    @Bean
    @ConditionalOnMissingBean
    public Interceptor mybatisPlusInterceptor() {
        MybatisPlusInterceptor interceptor = new MybatisPlusInterceptor();
        interceptor.addInnerInterceptor((InnerInterceptor)new PaginationInnerInterceptor());
        return interceptor;
    }

    public void insertFill(MetaObject metaObject) {
        this.setValueIfExists(metaObject, CREATOR, RequestContext.getUserId());
        this.setValueIfExists(metaObject, CREATE_TIME, LocalDateTime.now());
    }

    public void updateFill(MetaObject metaObject) {
        this.setValueIfExists(metaObject, MODIFIER, RequestContext.getUserId());
        this.setValueIfExists(metaObject, UPDATE_TIME, LocalDateTime.now());
    }

    private void setValueIfExists(MetaObject metaObject, String key, Object value) {
        if (metaObject.hasGetter(key) && metaObject.hasSetter(key)) {
            metaObject.setValue(key, value);
        }
    }
}

