package cn.zzq0324.radish.data.mybatis.repository;

import cn.zzq0324.radish.data.mybatis.entity.Entity;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;

/**
 * 抽象repository类
 *
 * @author  zzq0324
 * @since 1.0.0
 */
public abstract class AbstractRepository<M extends BaseMapper<D>, D extends Entity> extends ServiceImpl<M, D> {

  /**
   * 根据条件判断记录是否存在
   */
  public boolean exists(Wrapper<D> queryWrapper) {
    return getBaseMapper().exists(queryWrapper);
  }
}
