package cn.zzq0324.radish.data.mybatis.handler;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.MappedJdbcTypes;
import org.apache.ibatis.type.MappedTypes;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

/**
 * LocalDate类型转换
 *
 * @author  zzq0324
 * @since 1.0.0
 */
@Component
@MappedTypes(LocalDate.class)
@MappedJdbcTypes(value = JdbcType.DATE, includeNullJdbcType = true)
public class LocalDateTypeHandler extends BaseTypeHandler<LocalDate> {

  public static final String NORM_DATE_PATTERN = "yyyy-MM-dd";
  private final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(NORM_DATE_PATTERN);

  @Override
  public void setNonNullParameter(PreparedStatement ps, int i, LocalDate parameter, JdbcType jdbcType)
      throws SQLException {
    if (parameter != null) {
      ps.setString(i, dateTimeFormatter.format(parameter));
    }
  }

  @Override
  public LocalDate getNullableResult(ResultSet rs, String columnName) throws SQLException {
    String target = rs.getString(columnName);
    if (!StringUtils.hasText(target)) {
      return null;
    }
    return LocalDate.parse(target, dateTimeFormatter);
  }

  @Override
  public LocalDate getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
    String target = rs.getString(columnIndex);
    if (!StringUtils.hasText(target)) {
      return null;
    }
    return LocalDate.parse(target, dateTimeFormatter);
  }

  @Override
  public LocalDate getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
    String target = cs.getString(columnIndex);
    if (!StringUtils.hasText(target)) {
      return null;
    }
    return LocalDate.parse(target, dateTimeFormatter);
  }
}