package cn.zzq0324.radish.data.mybatis.handler;

import com.baomidou.mybatisplus.core.toolkit.StringPool;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.MappedJdbcTypes;
import org.apache.ibatis.type.MappedTypes;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

/**
 * LocalDateTime类型转换
 *
 * @author zzq0324
 * @since 1.0.0
 */
@Component
@MappedTypes(LocalDateTime.class)
@MappedJdbcTypes(value = JdbcType.DATE, includeNullJdbcType = true)
public class LocalDateTimeTypeHandler extends BaseTypeHandler<LocalDateTime> {

  public static final String NORM_DATETIME_PATTERN = "yyyy-MM-dd HH:mm:ss";
  public static final String NORM_DATETIME_MS_PATTERN = "yyyy-MM-dd HH:mm:ss.SSS";

  private final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(NORM_DATETIME_PATTERN);
  private final DateTimeFormatter dateTimeMsFormatter = DateTimeFormatter.ofPattern(NORM_DATETIME_MS_PATTERN);

  @Override
  public void setNonNullParameter(PreparedStatement ps, int i, LocalDateTime parameter, JdbcType jdbcType)
      throws SQLException {
    if (parameter != null) {
      ps.setString(i, dateTimeFormatter.format(parameter));
    }
  }

  @Override
  public LocalDateTime getNullableResult(ResultSet rs, String columnName) throws SQLException {
    String target = rs.getString(columnName);
    if (!StringUtils.hasText(target)) {
      return null;
    }
    if (target.contains(StringPool.DOT)) {
      return LocalDateTime.parse(target, dateTimeMsFormatter);
    }
    return LocalDateTime.parse(target, dateTimeFormatter);
  }

  @Override
  public LocalDateTime getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
    String target = rs.getString(columnIndex);
    if (!StringUtils.hasText(target)) {
      return null;
    }
    if (target.contains(StringPool.DOT)) {
      return LocalDateTime.parse(target, dateTimeMsFormatter);
    }
    return LocalDateTime.parse(target, dateTimeFormatter);
  }

  @Override
  public LocalDateTime getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
    String target = cs.getString(columnIndex);
    if (!StringUtils.hasText(target)) {
      return null;
    }
    if (target.contains(StringPool.DOT)) {
      return LocalDateTime.parse(target, dateTimeMsFormatter);
    }
    return LocalDateTime.parse(target, dateTimeFormatter);
  }
}
