package cn.zzq0324.radish.data.mybatis.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.time.LocalDateTime;
import lombok.Getter;
import lombok.Setter;

/**
 * 创建实体，包含创建人和创建时间
 *
 * @author zzq0324
 * @since : 1.0.0
 */
@Getter
@Setter
public abstract class CreateEntity<T> extends Entity<T> {

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT, value = "creator")
  private Long creator;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT, value = "create_time")
  protected LocalDateTime createTime;
}
