package cn.zzq0324.radish.data.mybatis.util;

import cn.zzq0324.radish.common.dto.request.PageRequest;
import cn.zzq0324.radish.common.dto.response.PageData;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.util.Assert;

/**
 * 分页转换工具
 *
 * @author: zzq0324
 * @since : 1.0.0
 */
public class MybatisUtils {

  /**
   * 分页转换为PageData
   */
  public static <T> PageData<T> pageToPageData(IPage<T> page) {
    Assert.notNull(page, "page must not be null");

    return new PageData<>((int) page.getTotal(), (int) page.getCurrent(), (int) page.getSize(), page.getRecords());
  }

  /**
   * 分页参数转换
   */
  public static <T> IPage<T> requestToPage(PageRequest pageRequest) {
    Page<T> page = new Page<>();
    page.setCurrent(pageRequest.getPage());
    page.setSize(pageRequest.getPageSize());

    return page;
  }
}
