package cn.zzq0324.radish.components.bizlog.infrastructure.entity;

import cn.zzq0324.radish.data.mybatis.entity.CreateEntity;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Getter;
import lombok.Setter;

/**
 * 日志模块
 *
 * @author: zzq0324
 * @since: 1.0.0
 */
@Getter
@Setter
@TableName("biz_log")
public class BizLogEntity extends CreateEntity<Long> {

  /**
   * 模块，例如订单模块等
   */
  @TableField("module")
  private String module;

  /**
   * 业务类型，例如支付
   */
  @TableField("biz_type")
  private String bizType;

  /**
   * 业务ID，例如支付的时候此处代表支付ID或者订单ID
   */
  @TableField("biz_id")
  private String bizId;

  /**
   * 日志内容
   */
  @TableField("content")
  private String content;

  /**
   * IP，用户请求时携带
   */
  @TableField("ip")
  private String ip;

  /**
   * 客户端信息
   */
  @TableField("user_agent")
  private String userAgent;
}
