/*
 * Decompiled with CFR 0.152.
 */
package cn.zyjblogs.crypto.sm2;

import cn.zyjblogs.crypto.SmException;
import cn.zyjblogs.crypto.sm2.SM2EngineExtend;
import cn.zyjblogs.crypto.sm2.SM2KeyPair;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.cert.X509Certificate;
import java.security.spec.KeySpec;
import java.util.Base64;
import java.util.Locale;
import java.util.Objects;
import org.bouncycastle.asn1.gm.GMNamedCurves;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jcajce.provider.asymmetric.x509.CertificateFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPrivateKeySpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.encoders.Hex;

public class SM2 {
    public static final String CRYPTO_NAME_SM2 = "sm2p256v1";
    public static final String BC04 = "04";
    private static final byte SM2_CIPHER_FIRST_BIT = 4;
    private static final int DEFAULT_KEY_SIZE = 128;

    public static SM2KeyPair generateSm2Keys(boolean compressed) {
        X9ECParameters sm2ECParameters = GMNamedCurves.getByName((String)CRYPTO_NAME_SM2);
        ECDomainParameters domainParameters = new ECDomainParameters(sm2ECParameters.getCurve(), sm2ECParameters.getG(), sm2ECParameters.getN());
        ECKeyPairGenerator keyPairGenerator = new ECKeyPairGenerator();
        keyPairGenerator.init((KeyGenerationParameters)new ECKeyGenerationParameters(domainParameters, new SecureRandom()));
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = keyPairGenerator.generateKeyPair();
        ECPublicKeyParameters publicKeyParameters = (ECPublicKeyParameters)asymmetricCipherKeyPair.getPublic();
        ECPoint ecPoint = publicKeyParameters.getQ();
        String publicKey = Hex.toHexString((byte[])ecPoint.getEncoded(compressed)).toUpperCase(Locale.ROOT);
        ECPrivateKeyParameters privateKeyParameters = (ECPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
        BigInteger intPrivateKey = privateKeyParameters.getD();
        String privateKey = intPrivateKey.toString(16).toUpperCase(Locale.ROOT);
        return new SM2KeyPair(publicKey, privateKey);
    }

    public static String encrypt(String pubKey, String data) {
        return SM2.encrypt(pubKey, data, SM2EngineExtend.CIPHER_MODE_NORM, EncodeType.UTF8, EncodeType.HEX);
    }

    public static String encrypt(String pubKey, String data, EncodeType inputType, EncodeType outType) {
        return SM2.encrypt(pubKey, data, SM2EngineExtend.CIPHER_MODE_NORM, inputType, outType);
    }

    public static String encrypt(String pubKey, String data, Mode mode, EncodeType inputType, EncodeType outType) {
        return SM2.encrypt(pubKey, data, Mode.CIPHER_MODE_BC == mode ? SM2EngineExtend.CIPHER_MODE_BC : SM2EngineExtend.CIPHER_MODE_NORM, inputType, outType);
    }

    public static String encrypt(String pubKey, String data, int cipherMode, EncodeType inputType, EncodeType outType) {
        if (Objects.equals((Object)EncodeType.UTF8, (Object)outType)) {
            throw new SmException("\u52a0\u5bc6\u6682\u4e0d\u652f\u6301UTF-8\u7f16\u7801\u683c\u5f0f\u6570\u636e\u8f93\u51fa!,\u8bf7\u4fee\u6539\u8f93\u51fa\u7c7b\u578b");
        }
        try {
            if (pubKey.length() == 128) {
                pubKey = BC04 + pubKey;
            }
            X9ECParameters sm2ECParameters = GMNamedCurves.getByName((String)CRYPTO_NAME_SM2);
            ECDomainParameters domainParameters = new ECDomainParameters(sm2ECParameters.getCurve(), sm2ECParameters.getG(), sm2ECParameters.getN());
            ECPoint pukPoint = sm2ECParameters.getCurve().decodePoint(Hex.decode((String)pubKey));
            ECPublicKeyParameters publicKeyParameters = new ECPublicKeyParameters(pukPoint, domainParameters);
            SM2EngineExtend sm2Engine = new SM2EngineExtend();
            sm2Engine.init(true, cipherMode, (CipherParameters)new ParametersWithRandom((CipherParameters)publicKeyParameters, new SecureRandom()));
            byte[] in = EncodeType.HEX.equals((Object)inputType) ? Hex.decode((String)data) : (EncodeType.BASE64.equals((Object)inputType) ? Base64.getDecoder().decode(data.getBytes(StandardCharsets.UTF_8)) : data.getBytes(StandardCharsets.UTF_8));
            return SM2.processBlock(sm2Engine, outType, in);
        }
        catch (InvalidCipherTextException e) {
            throw new SmException("\u52a0\u5bc6\u9519\u8bef", e);
        }
        catch (Exception e) {
            throw new SmException(e);
        }
    }

    private static String processBlock(SM2EngineExtend sm2Engine, EncodeType outType, byte[] in) throws InvalidCipherTextException {
        byte[] arrayOfBytes = sm2Engine.processBlock(in, 0, in.length);
        if (EncodeType.BASE64.equals((Object)outType)) {
            byte[] base64Bytes = Base64.getEncoder().encode(arrayOfBytes);
            return new String(base64Bytes, StandardCharsets.UTF_8);
        }
        if (EncodeType.HEX.equals((Object)outType)) {
            return Hex.toHexString((byte[])arrayOfBytes).toUpperCase(Locale.ROOT);
        }
        return new String(arrayOfBytes, StandardCharsets.UTF_8);
    }

    private static byte[] addBitIfNeed(byte[] base64Decode) {
        byte first = base64Decode[0];
        if (first == 4) {
            return base64Decode;
        }
        byte[] finalByte = new byte[base64Decode.length + 1];
        finalByte[0] = 4;
        System.arraycopy(base64Decode, 0, finalByte, 1, base64Decode.length);
        return finalByte;
    }

    public static String decrypt(String priKey, String cipherData) {
        return SM2.decrypt(priKey, cipherData, SM2EngineExtend.CIPHER_MODE_NORM, EncodeType.HEX, EncodeType.UTF8);
    }

    public static String decrypt(String priKey, String cipherData, EncodeType inputType, EncodeType outType) {
        return SM2.decrypt(priKey, cipherData, SM2EngineExtend.CIPHER_MODE_NORM, inputType, outType);
    }

    public static String decrypt(String priKey, String cipherData, int cipherMode, EncodeType inputType, EncodeType outType) {
        if (Objects.equals((Object)EncodeType.UTF8, (Object)inputType)) {
            throw new SmException("\u89e3\u5bc6\u6682\u4e0d\u652f\u6301UTF-8\u7f16\u7801\u683c\u5f0f\u6570\u636e\u8f93\u5165!,\u8bf7\u4fee\u6539\u8f93\u5165\u7c7b\u578b");
        }
        try {
            byte[] cipherDataByte;
            if (EncodeType.HEX.equals((Object)inputType)) {
                if (!cipherData.startsWith(BC04)) {
                    cipherData = BC04 + cipherData;
                }
                cipherDataByte = Hex.decode((String)cipherData);
            } else if (EncodeType.BASE64.equals((Object)inputType)) {
                cipherDataByte = Base64.getDecoder().decode(cipherData);
                cipherDataByte = SM2.addBitIfNeed(cipherDataByte);
            } else {
                cipherDataByte = cipherData.getBytes(StandardCharsets.UTF_8);
            }
            X9ECParameters sm2ECParameters = GMNamedCurves.getByName((String)CRYPTO_NAME_SM2);
            ECDomainParameters domainParameters = new ECDomainParameters(sm2ECParameters.getCurve(), sm2ECParameters.getG(), sm2ECParameters.getN());
            BigInteger privateKeyD = new BigInteger(priKey, 16);
            ECPrivateKeyParameters privateKeyParameters = new ECPrivateKeyParameters(privateKeyD, domainParameters);
            SM2EngineExtend sm2Engine = new SM2EngineExtend();
            sm2Engine.init(false, cipherMode, (CipherParameters)privateKeyParameters);
            return SM2.processBlock(sm2Engine, outType, cipherDataByte);
        }
        catch (InvalidCipherTextException e) {
            throw new SmException("\u89e3\u5bc6\u9519\u8bef", e);
        }
        catch (Exception e) {
            throw new SmException(e);
        }
    }

    public static String sign(String priKey, String plainText) {
        try {
            BouncyCastleProvider provider = new BouncyCastleProvider();
            X9ECParameters sm2ECParameters = GMNamedCurves.getByName((String)CRYPTO_NAME_SM2);
            ECParameterSpec ecParameterSpec = new ECParameterSpec(sm2ECParameters.getCurve(), sm2ECParameters.getG(), sm2ECParameters.getN(), sm2ECParameters.getH());
            KeyFactory keyFactory = KeyFactory.getInstance("EC", (Provider)provider);
            Signature signature = Signature.getInstance(GMObjectIdentifiers.sm2sign_with_sm3.toString(), (Provider)provider);
            BigInteger bigInteger = new BigInteger(priKey, 16);
            BCECPrivateKey bcecPrivateKey = (BCECPrivateKey)keyFactory.generatePrivate((KeySpec)new ECPrivateKeySpec(bigInteger, ecParameterSpec));
            signature.initSign((PrivateKey)bcecPrivateKey);
            signature.update(plainText.getBytes());
            return Hex.toHexString((byte[])signature.sign()).toUpperCase(Locale.ROOT);
        }
        catch (Exception e) {
            throw new SmException(e);
        }
    }

    public static boolean verify(String pubKey, String plainText, String signatureValue) {
        if (pubKey.length() == 128) {
            pubKey = BC04 + pubKey;
        }
        try {
            BouncyCastleProvider provider = new BouncyCastleProvider();
            X9ECParameters sm2ECParameters = GMNamedCurves.getByName((String)CRYPTO_NAME_SM2);
            ECParameterSpec ecParameterSpec = new ECParameterSpec(sm2ECParameters.getCurve(), sm2ECParameters.getG(), sm2ECParameters.getN(), sm2ECParameters.getH());
            KeyFactory keyFactory = KeyFactory.getInstance("EC", (Provider)provider);
            Signature signature = Signature.getInstance(GMObjectIdentifiers.sm2sign_with_sm3.toString(), (Provider)provider);
            ECPoint ecPoint = sm2ECParameters.getCurve().decodePoint(Hex.decode((String)pubKey));
            BCECPublicKey bcecPublicKey = (BCECPublicKey)keyFactory.generatePublic((KeySpec)new ECPublicKeySpec(ecPoint, ecParameterSpec));
            signature.initVerify((PublicKey)bcecPublicKey);
            signature.update(plainText.getBytes());
            return signature.verify(Hex.decode((String)signatureValue));
        }
        catch (Exception e) {
            throw new SmException(e);
        }
    }

    public static boolean certVerify(String certStr, String plaintext, String signValueStr) {
        try {
            BouncyCastleProvider provider = new BouncyCastleProvider();
            byte[] signValue = Hex.decode((String)signValueStr);
            CertificateFactory factory = new CertificateFactory();
            X509Certificate certificate = (X509Certificate)factory.engineGenerateCertificate((InputStream)new ByteArrayInputStream(Hex.decode((String)certStr)));
            Signature signature = Signature.getInstance(certificate.getSigAlgName(), (Provider)provider);
            signature.initVerify(certificate);
            signature.update(plaintext.getBytes());
            return signature.verify(signValue);
        }
        catch (Exception e) {
            throw new SmException(e);
        }
    }

    public static enum EncodeType {
        UTF8,
        HEX,
        BASE64;

    }

    public static enum Mode {
        CIPHER_MODE_BC,
        CIPHER_MODE_NORM;

    }
}

