/*
 * Decompiled with CFR 0.152.
 */
package cn.zyjblogs.crypto.sm4;

import cn.zyjblogs.crypto.SmException;
import cn.zyjblogs.crypto.sm3.SM3;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Locale;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Hex;

public class SM4 {
    private static final String SM4_ALGORITHM = "SM4";
    private static final int DEFAULT_KEY_SIZE = 128;
    private static final String TRANSFORMATION_CBC = "SM4/CBC/PKCS5Padding";
    private static final String TRANSFORMATION_ECB = "SM4/ECB/PKCS5Padding";

    public static String generateKey() {
        return SM4.generateKey(128);
    }

    public static String generateKey(int keySize) {
        try {
            KeyGenerator kg = KeyGenerator.getInstance(SM4_ALGORITHM, "BC");
            kg.init(keySize, new SecureRandom());
            byte[] encoded = kg.generateKey().getEncoded();
            return Hex.toHexString((byte[])encoded).toUpperCase(Locale.ROOT);
        }
        catch (Exception e) {
            throw new SmException(e);
        }
    }

    public static String encrypt(String keyHex, String planText, String ivHex) {
        try {
            Cipher cipher = Cipher.getInstance(TRANSFORMATION_CBC);
            SecretKeySpec keySpec = new SecretKeySpec(Hex.decode((String)keyHex), SM4_ALGORITHM);
            IvParameterSpec ivSpec = new IvParameterSpec(Hex.decode((String)ivHex));
            cipher.init(1, (Key)keySpec, ivSpec);
            byte[] outputBytes = cipher.doFinal(planText.getBytes(StandardCharsets.UTF_8));
            return Hex.toHexString((byte[])outputBytes).toUpperCase(Locale.ROOT);
        }
        catch (Exception e) {
            throw new SmException(e);
        }
    }

    public static String decrypt(String keyHex, String cipherDataHex, String ivHex) {
        try {
            Cipher cipher = Cipher.getInstance(TRANSFORMATION_CBC);
            SecretKeySpec keySpec = new SecretKeySpec(Hex.decode((String)keyHex), SM4_ALGORITHM);
            IvParameterSpec ivSpec = new IvParameterSpec(Hex.decode((String)ivHex));
            cipher.init(2, (Key)keySpec, ivSpec);
            byte[] outputBytes = cipher.doFinal(Hex.decode((String)cipherDataHex));
            return new String(outputBytes, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new SmException(e);
        }
    }

    public static String encrypt(String keyHex, String planText) {
        try {
            Cipher cipher = Cipher.getInstance(TRANSFORMATION_ECB);
            SecretKeySpec keySpec = new SecretKeySpec(Hex.decode((String)keyHex), SM4_ALGORITHM);
            cipher.init(1, keySpec);
            byte[] outputBytes = cipher.doFinal(planText.getBytes(StandardCharsets.UTF_8));
            return Hex.toHexString((byte[])outputBytes).toUpperCase(Locale.ROOT);
        }
        catch (Exception e) {
            throw new SmException(e);
        }
    }

    public static String decrypt(String keyHex, String cipherDataHex) {
        try {
            Cipher cipher = Cipher.getInstance(TRANSFORMATION_ECB);
            SecretKeySpec keySpec = new SecretKeySpec(Hex.decode((String)keyHex), SM4_ALGORITHM);
            cipher.init(2, keySpec);
            byte[] outputBytes = cipher.doFinal(Hex.decode((String)cipherDataHex));
            return new String(outputBytes, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new SmException(e);
        }
    }

    public static void main(String[] args) {
        String iv = SM4.generateKey();
        System.out.println(iv);
        System.out.println("\u52a0\u5bc6:---------");
        String v = SM4.encrypt(iv, "\u665a\u65e5\u7167\u7a7a\u77f6\uff0c\u91c7\u83b2\u627f\u665a\u6656\u3002\n                \u98ce\u8d77\u6e56\u96be\u6e21\uff0c\u83b2\u591a\u91c7\u672a\u7a00\u3002\n                \u68f9\u52a8\u8299\u84c9\u843d\uff0c\u8239\u79fb\u767d\u9e6d\u98de\u3002\n                \u8377\u4e1d\u508d\u7ed5\u8155\uff0c\u83f1\u89d2\u8fdc\u7275\u8863\u3002", iv);
        System.out.println(v);
        String digest = SM3.digest(v);
        System.out.println(digest);
        System.out.println("\u89e3\u5bc6:---------");
        System.out.println(SM4.decrypt(iv, v, iv));
        System.out.println("\u89e3\u5bc6:---------");
        System.out.println(SM4.decrypt("864669EB9E57E15C923E1003CBEA8872", "6a05d74bda1f2a41c0b47605b06ef638", "fedcba98765432100123456789abcdef"));
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

