/*
 * Decompiled with CFR 0.152.
 */
package cn.zyjblogs.crypto.sm3;

import java.nio.charset.StandardCharsets;
import java.util.Locale;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.util.encoders.Hex;

public class SM3 {
    public static String digest(String input) {
        SM3Digest sm3Digest = new SM3Digest();
        byte[] bytes = input.getBytes(StandardCharsets.UTF_8);
        byte[] out = new byte[32];
        sm3Digest.update(bytes, 0, bytes.length);
        sm3Digest.doFinal(out, 0);
        return Hex.toHexString((byte[])out).toUpperCase(Locale.ROOT);
    }

    public static String hmac(String key, String data) {
        byte[] bytes = data.getBytes(StandardCharsets.UTF_8);
        KeyParameter keyParameter = new KeyParameter(key.getBytes(StandardCharsets.UTF_8));
        SM3Digest digest = new SM3Digest();
        HMac mac = new HMac((Digest)digest);
        mac.init((CipherParameters)keyParameter);
        mac.update(bytes, 0, bytes.length);
        byte[] out = new byte[32];
        mac.doFinal(out, 0);
        return Hex.toHexString((byte[])out).toUpperCase(Locale.ROOT);
    }

    public static boolean verify(String data, String hash) {
        String srcHash = SM3.digest(data);
        return hash.equals(srcHash);
    }

    public static boolean verify(String key, String data, String hmac) {
        String srcHmac = SM3.hmac(key, data);
        return hmac.equals(srcHmac);
    }

    public static void main(String[] args) {
        String a = SM3.digest("aaaa");
        System.out.println(a);
        System.out.println(SM3.verify("aaaa", a));
    }
}

