package cn.zxinrun.excel.enums;

/**
 * 导出字段类型
 * @author Mr.Zhang
 * @since 1.0
 **/
public enum ColumnTypeEnum {

    // 数字
    NUMERIC(0),
    // 字符串
    STRING(1),
    // 图片
    IMAGE(2),
    // 文本
    TEXT(3);

    private final int value;

    ColumnTypeEnum(int value) {
        this.value = value;
    }

    /**
     * 获取值
     * @return int
     */
    public int value() {
        return this.value;
    }

}
