package cn.zxinrun.core.util.file;

import cn.hutool.core.io.FileUtil;

/**
 * 文件工具类
 * @author Mr.Zhang
 * @since 1.0
 **/
public class FileUtils extends FileUtil {

    // 定义GB的计算常量
    public static final int GB = 1024 * 1024 * 1024;

    // 定义MB的计算常量
    public static final int MB = 1024 * 1024;

    // 定义KB的计算常量
    public static final int KB = 1024;

    /**
     * 获取文件类型
     * @param suffix 文件后缀
     * @return 格式化中文
     */
    public static String getFileType(String suffix) {
        String documents = "txt doc pdf ppt pps xlsx xls docx";
        String music = "mp3 wav wma mpa ram ra aac aif m4a";
        String video = "avi mpg mpe mpeg asf wmv mov qt rm mp4 flv m4v webm ogv ogg";
        String image = "bmp dib pcp dif wmf gif jpg tif eps psd cdr iff tga pcd mpt png jpeg";
        if (image.contains(suffix)) return "图片";
        if (documents.contains(suffix)) return "文档";
        if (music.contains(suffix)) return "音乐";
        if (video.contains(suffix)) return "视频";
        return "其他";
    }

}
