package cn.zxinrun.core.constant;

/**
 * 全局通用常量
 * @author Mr.Zhang
 * @since 1.0
 **/
public interface CommonConstants {

    // 编码
    String UTF8 = "UTF-8";
    // 默认国际化
    String DEFAULT_LOCALE = "zh_CN";

    // redis 协议
    String REDIS = "redis://";
    // http请求
    String HTTP = "http://";
    // https请求
    String HTTPS = "https://";

    // 本地局域网host
    String LOCAL_HOST = "127.0.0.1";
    // 本地局域网host
    String LOCAL_HOST_IPV6 = "::1";
    // JSON 资源
    String CONTENT_TYPE = "application/json; charset=utf-8";

    // 成功标记
    int SUCCESS = 200;
    // 失败标记
    int FAIL = 500;
    // 成功文案
    String SUCCESS_TEXT = "操作成功!";
    // 失败文案
    String FAIL_TEXT = "操作失败!";

    // 零
    String ZERO = "0";

    // Y
    String Y = "Y";
    // N
    String N = "N";

    // 当前页
    String CURRENT = "current";
    // 每页显示记录条数
    String SIZE = "size";

    // 请求开始时间
    String REQUEST_START_TIME = "REQUEST-START-TIME";
    // 表示 HTTP 请求端真实 IP
    String X_FORWARDED_FOR = "X-Forwarded-For";

    // Mac
    String MAC = "Mac";
    // Windows
    String WINDOWS = "Windows";
    // Linux
    String LINUX = "Linux";

    // 暂未支持
    String NOT_SUPPORTED = "Not supported yet!";

}
