/*
 * Decompiled with CFR 0.152.
 */
package cn.zxinrun.core.util;

import org.apache.commons.lang3.StringUtils;

public class StringUtil
extends StringUtils {
    private static final char UNDER_LINE = '_';
    public static final String SEPARATOR = ",";
    public static final String SLASH = "/";

    public static String trim(String str) {
        return str == null ? "" : str.trim();
    }

    public static boolean hasText(String str) {
        return str != null && !str.isEmpty() && StringUtil.containsText(str);
    }

    private static boolean containsText(CharSequence str) {
        int strLen = str.length();
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean inStringIgnoreCase(String str, String ... strs) {
        if (str != null && strs != null) {
            for (String s : strs) {
                if (!str.equalsIgnoreCase(StringUtil.trim(s))) continue;
                return true;
            }
        }
        return false;
    }

    public static String toUnderScoreCase(String str) {
        if (str == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean preCharIsUpperCase = true;
        boolean curreCharIsUpperCase = true;
        boolean nexteCharIsUpperCase = true;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            preCharIsUpperCase = i > 0 ? Character.isUpperCase(str.charAt(i - 1)) : false;
            curreCharIsUpperCase = Character.isUpperCase(c);
            if (i < str.length() - 1) {
                nexteCharIsUpperCase = Character.isUpperCase(str.charAt(i + 1));
            }
            if (preCharIsUpperCase && curreCharIsUpperCase && !nexteCharIsUpperCase) {
                sb.append('_');
            } else if (i != 0 && !preCharIsUpperCase && curreCharIsUpperCase) {
                sb.append('_');
            }
            sb.append(Character.toLowerCase(c));
        }
        return sb.toString();
    }

    public static String convertToCamelCase(String name) {
        String[] camels;
        StringBuilder result = new StringBuilder();
        if (name == null || name.isEmpty()) {
            return "";
        }
        if (!name.contains("_")) {
            return name.substring(0, 1).toUpperCase() + name.substring(1);
        }
        for (String camel : camels = name.split("_")) {
            if (camel.isEmpty()) continue;
            result.append(camel.substring(0, 1).toUpperCase());
            result.append(camel.substring(1).toLowerCase());
        }
        return result.toString();
    }

    public static String toCamelCase(String str) {
        if (str == null) {
            return null;
        }
        str = str.toLowerCase();
        StringBuilder sb = new StringBuilder(str.length());
        boolean upperCase = false;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '_') {
                upperCase = true;
                continue;
            }
            if (upperCase) {
                sb.append(Character.toUpperCase(c));
                upperCase = false;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String padl(Number num, int size) {
        return StringUtil.padl(num.toString(), size, '0');
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String padl(String s, int size, char c) {
        StringBuilder sb = new StringBuilder(size);
        if (s != null) {
            int len = s.length();
            if (s.length() > size) return s.substring(len - size, len);
            for (int i = size - len; i > 0; --i) {
                sb.append(c);
            }
            sb.append(s);
            return sb.toString();
        } else {
            for (int i = size; i > 0; --i) {
                sb.append(c);
            }
        }
        return sb.toString();
    }
}

