/*
 * Decompiled with CFR 0.152.
 */
package cn.zvo.log.datasource.elasticsearch;

import cn.zvo.log.DatasourceInterface;
import cn.zvo.log.vo.LogListVO;
import com.xnx3.Lang;
import com.xnx3.StringUtil;
import com.xnx3.elasticsearch.ElasticSearchUtil;
import com.xnx3.elasticsearch.jsonFormat.JsonFormatInterface;
import com.xnx3.j2ee.Global;
import com.xnx3.j2ee.util.ConsoleUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.core.CountRequest;
import org.elasticsearch.client.core.CountResponse;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.QueryStringQueryBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;

public class ElasticSearchDataSource
implements DatasourceInterface {
    public static final int PORT_DEFAULT = 9200;
    public static ElasticSearchUtil es;

    public ElasticSearchDataSource(String hostname, int port, String scheme, String username, String password, String indexName) {
        this.init(hostname, port, scheme, username, password);
    }

    public ElasticSearchDataSource(Map<String, String> config) {
        String hostname = config.get("hostname");
        int port = Lang.stringToInt((String)config.get("port"), (int)9200);
        String scheme = config.get("scheme");
        String username = config.get("username");
        String password = config.get("password");
        this.init(hostname, port, scheme, username, password);
    }

    public void init(String hostname, int port, String scheme, String username, String password) {
        if (hostname != null && hostname.length() > 0) {
            es = new ElasticSearchUtil(hostname, port, scheme);
            if (username != null && username.length() > 0 && password != null && password.length() > 0) {
                es.setUsernameAndPassword(username, password);
            }
            es.setJsonFormatInterface(new JsonFormatInterface(){

                public String mapToJsonString(Map<String, Object> params) {
                    if (params == null) {
                        params = new HashMap<String, Object>();
                    }
                    return JSONObject.fromObject(params).toString();
                }
            });
        }
    }

    public static void main(String[] args) {
        String indexName = "useraction";
        String queryString = "time > 0";
        Global.system.put("a", "");
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        CountRequest countRequest = new CountRequest();
        if (queryString != null && queryString.length() > 0) {
            QueryStringQueryBuilder queryBuilder = QueryBuilders.queryStringQuery((String)queryString);
            searchSourceBuilder.query((QueryBuilder)queryBuilder);
        }
        countRequest.indices(new String[]{indexName}).source(searchSourceBuilder);
        CountResponse countResponse = null;
        try {
            countResponse = es.getRestHighLevelClient().count(countRequest, RequestOptions.DEFAULT);
            System.out.println("countResponse.getCount(): " + countResponse.getCount());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean commit(String table, List<Map<String, Object>> list) {
        ElasticSearchDataSource.es.cacheMap.put(table, list);
        return es.cacheSubmit(table);
    }

    public LogListVO list(String table, String query, int everyPageNumber, int currentPage) {
        LogListVO vo = new LogListVO();
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        CountRequest countRequest = new CountRequest();
        if (query != null && query.length() > 0) {
            QueryStringQueryBuilder queryBuilder = QueryBuilders.queryStringQuery((String)query);
            searchSourceBuilder.query((QueryBuilder)queryBuilder);
        }
        countRequest.indices(new String[]{table}).source(searchSourceBuilder);
        long count = 0L;
        CountResponse countResponse = null;
        try {
            countResponse = es.getRestHighLevelClient().count(countRequest, RequestOptions.DEFAULT);
            count = countResponse.getCount();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int limitNumber = everyPageNumber;
        long max_result_window = 10000L;
        try {
            Response res = es.getRestClient().performRequest(new Request("GET", "/" + table + "/_settings"));
            String text = StringUtil.inputStreamToString((InputStream)res.getEntity().getContent(), (String)"UTF-8");
            JSONObject setJson = JSONObject.fromObject((Object)text);
            JSONObject indexJson = setJson.getJSONObject(table).getJSONObject("settings").getJSONObject("index");
            if (indexJson.get("max_result_window") != null) {
                max_result_window = indexJson.getLong("max_result_window");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int limitStart = (currentPage - 1) * everyPageNumber;
        if ((long)(limitStart + limitNumber) > max_result_window) {
            vo.setBaseVO(0, "\u663e\u793a\u6700\u5927\u6761\u6570\u8d85\u8fc7\u7cfb\u7edf\u9884\u8bbe\u4f18\u5316\u7684\u6700\u5927\u6761\u6570" + max_result_window + "\u6761\u3002\u4f60\u53ef\u4ee5\u8bbe\u7f6eElasticSearch\u4e2d\uff0c\u5f53\u524d\u7d22\u5f15\u7684max_result_window\u5c5e\u6027\u6765\u8bbe\u7f6e\u66f4\u5927\u6761\u6570\u3002");
            ConsoleUtil.log((String)("\u663e\u793a\u6700\u5927\u6761\u6570\u8d85\u8fc7\u7cfb\u7edf\u9884\u8bbe\u4f18\u5316\u7684\u6700\u5927\u6761\u6570" + max_result_window + "\u6761\u3002\u4f60\u53ef\u4ee5\u8bbe\u7f6eElasticSearch\u4e2d\uff0c" + table + "\u7d22\u5f15\u7684max_result_window\u5c5e\u6027\u6765\u8bbe\u7f6e\u66f4\u5927\u6761\u6570\u3002"));
            return vo;
        }
        List list = es.search(table, query, Integer.valueOf(limitStart), Integer.valueOf(limitNumber), SortBuilders.fieldSort((String)"time").order(SortOrder.DESC));
        for (int i = 0; i < list.size(); ++i) {
            Map map = (Map)list.get(i);
            Object timeObj = map.get("time");
            if (timeObj == null) {
                map.put("logtime", 0L);
                continue;
            }
            map.put("logtime", timeObj);
        }
        vo.setJsonArray(JSONArray.fromObject((Object)list));
        return vo;
    }
}

