/*
 * Decompiled with CFR 0.152.
 */
package cn.zvo.log.datasource.aliyunSLS;

import cn.zvo.log.DatasourceInterface;
import cn.zvo.log.datasource.aliyunSLS.AliyunLogPageUtil;
import cn.zvo.log.datasource.aliyunSLS.AliyunLogUtil;
import cn.zvo.log.vo.LogListVO;
import cn.zvo.page.Page;
import com.aliyun.openservices.log.common.LogContent;
import com.aliyun.openservices.log.common.LogItem;
import com.aliyun.openservices.log.exception.LogException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;

public class AliyunSLSDataSource
implements DatasourceInterface {
    public static final int CACHE_MAX_TIME_DEFAULT = 120;
    public static final int CACHE_MAX_NUMBER_DEFAULT = 100;
    public static AliyunLogUtil aliyunLogUtil = null;
    AliyunLogPageUtil logPage;

    public AliyunSLSDataSource(Map<String, String> config) {
        String accessKeyId = config.get("accessKeyId");
        String accessKeySecret = config.get("accessKeySecret");
        String endpoint = config.get("endpoint");
        String project = config.get("project");
        this.init(accessKeyId, accessKeySecret, endpoint, project);
    }

    public void init(String accessKeyId, String accessKeySecret, String endpoint, String project) {
        aliyunLogUtil = new AliyunLogUtil(endpoint, accessKeyId, accessKeySecret, project);
        aliyunLogUtil.setStackTraceDeep(5);
        this.logPage = new AliyunLogPageUtil(aliyunLogUtil);
    }

    public static Map<String, Object> logitemToMap(LogItem logItem) {
        if (logItem == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList array = logItem.GetLogContents();
        for (int i = 0; i < array.size(); ++i) {
            LogContent log = (LogContent)array.get(i);
            map.put(log.GetKey(), log.GetValue());
        }
        return map;
    }

    public LogListVO list(String table, String query, int everyPageNumber, int currentPage) {
        JSONArray jsonArray = null;
        try {
            jsonArray = this.logPage.list(table, query, "", true, everyPageNumber, currentPage);
        }
        catch (LogException e) {
            e.printStackTrace();
        }
        if (jsonArray == null) {
            jsonArray = new JSONArray();
        }
        Page page = this.logPage.getPage();
        LogListVO vo = new LogListVO();
        vo.setJsonArray(jsonArray);
        vo.setPage(page);
        return vo;
    }

    public boolean commit(String table, List<Map<String, Object>> list) {
        if (aliyunLogUtil == null) {
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            Map<String, Object> map = list.get(i);
            LogItem logItem = AliyunSLSDataSource.mapToLogitem(map);
            AliyunSLSDataSource.aliyunLogUtil.logGroupCache.add(logItem);
        }
        try {
            aliyunLogUtil.cacheCommit(table);
        }
        catch (LogException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static LogItem mapToLogitem(Map<String, Object> map) {
        LogItem logItem = aliyunLogUtil.newLogItem();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String value = null;
            value = entry.getValue() == null ? "" : entry.getValue().toString() + "";
            logItem.PushBack(entry.getKey(), value);
        }
        return logItem;
    }
}

