/*
 * Decompiled with CFR 0.152.
 */
package cn.zull.tracing.mybatis;

import cn.zull.tracing.core.UnilateralTraceContext;
import cn.zull.tracing.core.after.TracingLogPostProcessingUtils;
import cn.zull.tracing.core.dto.TraceDTO;
import cn.zull.tracing.core.exception.TracingInnerException;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class})})
public class TracingInterceptor
implements Interceptor {
    @Autowired
    UnilateralTraceContext unilateralTraceContext;

    public TracingInterceptor() {
        System.out.println("Mybatis Interceptor");
    }

    public Object intercept(Invocation invocation) throws Throwable {
        TraceDTO traceDTO = this.unilateralTraceContext.provider();
        return TracingLogPostProcessingUtils.collectionLog((TraceDTO)traceDTO, traceLog -> {
            try {
                traceLog.setTraceType("mysql");
                return invocation.proceed();
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new TracingInnerException((Throwable)e);
            }
        });
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }
}

