/*
 * Decompiled with CFR 0.152.
 */
package cn.zull.tracing.dubbo;

import cn.zull.tracing.core.AbstractTraceContext;
import cn.zull.tracing.core.dto.TraceDTO;
import cn.zull.tracing.dubbo.RpcTraceContext;
import com.alibaba.dubbo.rpc.RpcContext;
import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import javax.validation.constraints.NotNull;
import org.springframework.stereotype.Component;

@Component
public class DubboTraceContext
extends AbstractTraceContext
implements RpcTraceContext {
    @Override
    public TraceDTO consumer(@NotNull Consumer<TraceDTO> traceDTOConsumer) {
        TraceDTO traceDTO = this.getTraceDTOByRpcContext().spanIdAddLevel();
        traceDTOConsumer.accept(traceDTO);
        this.printTraceLog(traceDTO);
        this.setContext(traceDTO);
        return traceDTO;
    }

    @Override
    public TraceDTO product() {
        return super.getContextAndSpanIdPlusOne(traceDTO -> RpcContext.getContext().setAttachments(this.traceDto2Map((TraceDTO)traceDTO)));
    }

    private TraceDTO getTraceDTOByRpcContext() {
        Map map = RpcContext.getContext().getAttachments();
        return this.map2TraceDto(map);
    }

    protected Map<String, String> traceDto2Map(TraceDTO traceDTO) {
        HashMap<String, String> map = new HashMap<String, String>(3);
        map.put("traceId", traceDTO.getTraceId());
        map.put("spanId", traceDTO.getSpanId());
        map.put("ctm", traceDTO.getCtm());
        map.put("properties", JSON.toJSONString((Object)traceDTO.getProperties()));
        return map;
    }

    protected TraceDTO map2TraceDto(Map<String, String> map) {
        TraceDTO traceDTO = TraceDTO.getInstance();
        traceDTO.setTraceId(map.get("traceId"));
        traceDTO.setSpanId(map.get("spanId"));
        traceDTO.setCtm(map.get("ctm"));
        traceDTO.setProperties((Object)JSON.parseObject((String)map.get("properties")));
        return traceDTO;
    }

    @Override
    public void addRpcContext() {
    }
}

