/*
 * Decompiled with CFR 0.152.
 */
package cn.zull.tracing.dubbo.filter;

import cn.zull.tracing.core.utils.SpringApplicationContext;
import cn.zull.tracing.dubbo.DubboTraceContext;
import cn.zull.tracing.dubbo.RpcTraceContext;
import com.alibaba.dubbo.common.extension.Activate;
import com.alibaba.dubbo.rpc.Filter;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.Result;
import com.alibaba.dubbo.rpc.RpcException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Activate(group={"provider", "consumer"})
public class DubboFilter
implements Filter {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private volatile RpcTraceContext traceContext;

    public DubboFilter() {
        System.out.println("-------Dubbo Filter-------");
    }

    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        this.logger.info("dubbo filter");
        String sideVal = invoker.getUrl().getParameter("side");
        if ("consumer".equals(sideVal)) {
            this.getTraceContext().product();
        } else if ("provider".equals(sideVal)) {
            this.getTraceContext().consumer(traceDTO -> {});
        }
        return invoker.invoke(invocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private RpcTraceContext getTraceContext() {
        if (this.traceContext != null) return this.traceContext;
        Class<RpcTraceContext> clazz = RpcTraceContext.class;
        synchronized (RpcTraceContext.class) {
            if (this.traceContext == null) {
                this.traceContext = (RpcTraceContext)SpringApplicationContext.getBean(DubboTraceContext.class);
            }
            if (this.traceContext != null) return this.traceContext;
            this.logger.error("RpcTraceContext is null");
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.traceContext;
        }
    }
}

