/*
 * Decompiled with CFR 0.152.
 */
package cn.zull.tracing.dubbo;

import cn.zull.tracing.core.AbstractTraceContext;
import cn.zull.tracing.core.dto.TraceDTO;
import cn.zull.tracing.dubbo.RpcTraceContext;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public abstract class AbstractRpcTraceContext
extends AbstractTraceContext
implements RpcTraceContext {
    public TraceDTO getTraceDto() {
        return Optional.ofNullable(super.getTraceDto()).orElseGet(this::getTraceBoByRpcContext);
    }

    public abstract Map<String, String> rpcValues();

    private TraceDTO getTraceBoByRpcContext() {
        TraceDTO traceDTO = this.map2TraceDto(this.rpcValues());
        if (traceDTO != null) {
            context.set(traceDTO);
        }
        return (TraceDTO)context.get();
    }

    protected Map<String, String> traceBo2Map(TraceDTO traceBO) {
        HashMap<String, String> map = new HashMap<String, String>(3);
        map.put("traceId", traceBO.getTraceId());
        map.put("spanId", traceBO.getSpanId());
        return map;
    }

    protected TraceDTO map2TraceDto(Map<String, String> map) {
        TraceDTO traceBO = new TraceDTO();
        traceBO.setTraceId(map.get("traceId"));
        traceBO.setSpanId(map.get("spanId"));
        return traceBO;
    }
}

