/*
 * Decompiled with CFR 0.152.
 */
package cn.zongkuiy.menuconsole;

import cn.zongkuiy.menuconsole.Menu;
import cn.zongkuiy.menuconsole.MenuEntry;
import cn.zongkuiy.menuconsole.SocketInfo;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class MenuSystem
extends Thread {
    private static MenuSystem instance;
    private Menu rootMenu;
    private List<Socket> currSocket = new ArrayList<Socket>();
    private ServerSocket serverSocket;
    private boolean destroyFlag = false;
    private ConcurrentHashMap<String, Menu> menuMap = new ConcurrentHashMap();
    private static int listenPort;
    private static String bindIp;
    private static String title;
    private static final String ROOT_MENU_ID = "i_am_root_menu";
    public static ThreadLocal<SocketInfo> socketLocal;

    public static void setBindIp(String _bindIp) {
        bindIp = _bindIp;
    }

    public static void setListenPort(int _listenPort) {
        listenPort = _listenPort;
    }

    public static void setTitle(String _title) {
        title = _title;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MenuSystem getInstance() {
        if (instance != null) return instance;
        Class<MenuSystem> clazz = MenuSystem.class;
        synchronized (MenuSystem.class) {
            if (instance != null) return instance;
            instance = new MenuSystem();
            instance.start();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private MenuSystem() {
        this.setName(title);
        this.rootMenu = new Menu(title);
        this.menuMap.put(ROOT_MENU_ID, this.rootMenu);
    }

    public void destroy() {
        try {
            if (this.serverSocket != null) {
                this.serverSocket.close();
            }
            if (this.currSocket != null && this.currSocket.size() > 0) {
                for (Socket s : this.currSocket) {
                    s.close();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.destroyFlag = true;
    }

    public Menu getRootMenu() {
        return this.rootMenu;
    }

    public void run() {
        try {
            InetAddress inetAddr = InetAddress.getByName(bindIp);
            this.serverSocket = new ServerSocket(listenPort, 1, inetAddr);
            while (!this.destroyFlag) {
                Socket socket = this.serverSocket.accept();
                this.currSocket.add(socket);
                new Thread(new DataThread(socket)).start();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void println(String msg) {
        socketLocal.get().getPs().println(msg);
    }

    public void print(String msg) {
        socketLocal.get().getPs().print(msg);
    }

    public String read() {
        BufferedReader in = new BufferedReader(new InputStreamReader(socketLocal.get().getIs()));
        try {
            String readStr = in.readLine();
            return readStr;
        }
        catch (IOException e) {
            e.printStackTrace(socketLocal.get().getPs());
            return null;
        }
    }

    public Menu addMenu(String title, Menu parentMenu) {
        return new Menu(parentMenu, title);
    }

    public void addMenuEntry(String title, Object obj, String methodName, Menu parentMenu) {
        new MenuEntry(title, parentMenu, obj, methodName);
    }

    static {
        listenPort = 7000;
        bindIp = "127.0.0.1";
        title = "Debug Console";
        socketLocal = new ThreadLocal();
    }

    private class DataThread
    implements Runnable {
        Socket socket;

        public DataThread(Socket socket) {
            this.socket = socket;
        }

        public void run() {
            if (this.socket != null) {
                try {
                    socketLocal.set(new SocketInfo(this.socket, new PrintStream(this.socket.getOutputStream()), this.socket.getInputStream()));
                    MenuSystem.getInstance().println("==============================================");
                    MenuSystem.getInstance().println("Current Online User Count: ");
                    MenuSystem.getInstance().println("==============================================");
                    MenuSystem.this.rootMenu.execute();
                    this.socket.close();
                }
                catch (Exception e) {
                    try {
                        this.socket.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return;
            }
        }
    }
}

