/*
 * Decompiled with CFR 0.152.
 */
package cn.zongkuiy.menuconsole;

import cn.zongkuiy.menuconsole.Menu;
import cn.zongkuiy.menuconsole.MenuBase;
import cn.zongkuiy.menuconsole.MenuSystem;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class MenuEntry
extends MenuBase {
    private Object obj;
    private String methodName;

    public MenuEntry(String menuEntryName, Menu parentMenu, Object obj, String methodName) {
        super(menuEntryName);
        this.obj = obj;
        this.methodName = methodName;
        parentMenu.addEntry(this);
    }

    public void execute() {
        Method method;
        if (this.obj == null) {
            return;
        }
        Class<?> cls = this.obj.getClass();
        try {
            method = cls.getMethod(this.methodName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            MenuSystem.getInstance().println("NoSuchMethodException, method name is " + this.methodName);
            return;
        }
        try {
            method.invoke(this.obj, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            MenuSystem.getInstance().println("IllegalArgumentException, method name is " + this.methodName);
        }
        catch (IllegalAccessException e) {
            MenuSystem.getInstance().println("IllegalAccessException, method name is " + this.methodName);
        }
        catch (InvocationTargetException e) {
            MenuSystem.getInstance().println("InvocationTargetException, method name is " + this.methodName);
        }
    }

    public void print() {
        MenuSystem.getInstance().println(this.name);
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public Object getObj() {
        return this.obj;
    }

    public void setObj(Object obj) {
        this.obj = obj;
    }
}

