/*
 * Decompiled with CFR 0.152.
 */
package cn.zongkuiy.menuconsole;

import cn.zongkuiy.menuconsole.MenuSystem;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Socket;

public abstract class MenuBase {
    protected String name;

    public abstract void print();

    public abstract void execute();

    public abstract void setName(String var1);

    public MenuBase(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static int getInt(String prompt, int minVal, int maxVal) throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader(MenuSystem.socketLocal.get().getIs()));
        String str = "";
        while (!MenuSystem.socketLocal.get().getPs().checkError()) {
            MenuSystem.getInstance().println(prompt);
            str = in.readLine();
            if (str == null) {
                throw new IOException();
            }
            if (str != null && str.length() > 0) {
                try {
                    int response = Integer.parseInt(str);
                    if (response >= minVal && response <= maxVal) {
                        return response;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            MenuSystem.getInstance().println("[ERROR] Invalid Value, please enter a value between " + minVal + " and " + maxVal);
        }
        throw new IOException();
    }

    public static int getInt(String prompt, int minVal, int maxVal, int specificVal, Socket s) throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader(MenuSystem.socketLocal.get().getIs()));
        String str = "";
        while (!MenuSystem.socketLocal.get().getPs().checkError()) {
            MenuSystem.getInstance().println(prompt);
            str = in.readLine();
            if (str == null) {
                throw new IOException();
            }
            if (str != null && str.length() > 0) {
                try {
                    int response = Integer.parseInt(str);
                    if (response >= minVal && response <= maxVal) {
                        return response;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            MenuSystem.getInstance().println("[ERROR] Invalid Value, please enter a value between " + minVal + " and " + maxVal + " or enter " + specificVal);
        }
        throw new IOException();
    }

    public static String getString(String prompt) throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader(MenuSystem.socketLocal.get().getIs()));
        String str = "";
        while (!MenuSystem.socketLocal.get().getPs().checkError()) {
            MenuSystem.getInstance().println(prompt);
            str = in.readLine();
            if (str == null) {
                throw new IOException();
            }
            if (str != null && str.length() > 0) {
                return str;
            }
            MenuSystem.getInstance().println("[ERROR] Invalid Value, please enter a valid string ");
        }
        throw new IOException();
    }
}

