/*
 * Decompiled with CFR 0.152.
 */
package cn.zongkuiy.menuconsole;

import cn.zongkuiy.menuconsole.MenuBase;
import cn.zongkuiy.menuconsole.MenuSystem;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Menu
extends MenuBase {
    private ArrayList<MenuBase> menuElements = new ArrayList();
    private Menu parentMenu;

    public Menu(Menu menu, String menuName) {
        super(menuName);
        this.parentMenu = menu;
        this.parentMenu.addEntry(this);
    }

    public Menu(String menuName) {
        super(menuName);
        this.parentMenu = null;
    }

    public Menu getParentMenu() {
        return this.parentMenu;
    }

    @Override
    public void setName(String newName) {
        if (this.isNameIgnored(newName) || !this.isSubMenuNameExisting(newName)) {
            this.name = newName;
        }
    }

    private ArrayList<MenuBase> printMenu() {
        int i;
        MenuSystem.getInstance().println("");
        ArrayList<String> pathStrs = new ArrayList<String>();
        pathStrs.add(this.name);
        Menu parent = this.parentMenu;
        while (parent != null) {
            pathStrs.add(" >> ");
            pathStrs.add(parent.name);
            parent = parent.parentMenu;
        }
        for (i = pathStrs.size() - 1; i >= 0; --i) {
            MenuSystem.getInstance().print((String)pathStrs.get(i));
        }
        MenuSystem.getInstance().println("");
        for (i = 0; i < this.name.length(); ++i) {
            MenuSystem.getInstance().print("-");
        }
        MenuSystem.getInstance().println("");
        MenuSystem.getInstance().println("0. Return");
        ArrayList<MenuBase> tmpMenuElements = new ArrayList<MenuBase>();
        int index = 0;
        for (int i2 = 0; i2 < this.menuElements.size(); ++i2) {
            MenuBase tmpMenuElement = this.menuElements.get(i2);
            if (this.isNameIgnored(tmpMenuElement.getName())) continue;
            MenuSystem.getInstance().print(index + 1 + ". ");
            tmpMenuElement.print();
            tmpMenuElements.add(tmpMenuElement);
            ++index;
        }
        return tmpMenuElements;
    }

    @Override
    public void execute() {
        while (!MenuSystem.socketLocal.get().getPs().checkError()) {
            ArrayList<MenuBase> tmpMenuElements = this.printMenu();
            try {
                int response = Menu.getInt("Enter the number :", 0, tmpMenuElements.size());
                if (response == 0) {
                    return;
                }
                MenuBase menuElement = tmpMenuElements.get(response - 1);
                if (menuElement == null) continue;
                menuElement.execute();
            }
            catch (Exception e) {
                return;
            }
        }
    }

    @Override
    public void print() {
        MenuSystem.getInstance().println(this.name);
    }

    public void addEntry(MenuBase menuElement) {
        String menuElementName;
        if (menuElement != null && !this.isSubMenuNameExisting(menuElementName = menuElement.getName())) {
            this.menuElements.add(menuElement);
        }
    }

    public void delEntry(MenuBase menuElement) {
        if (menuElement != null) {
            this.menuElements.remove(menuElement);
        }
    }

    private boolean isSubMenuNameExisting(String subMenuName) {
        if (this.isNameIgnored(subMenuName)) {
            return false;
        }
        for (int i = 0; i < this.menuElements.size(); ++i) {
            String tmpName = this.menuElements.get(i).getName();
            if (this.isNameIgnored(tmpName) || !tmpName.equals(subMenuName)) continue;
            return true;
        }
        return false;
    }

    private boolean isNameIgnored(String menuElementName) {
        return menuElementName == null || menuElementName.trim().length() == 0;
    }
}

