package com.kyle.component.kdb.manager;

import android.database.sqlite.SQLiteDatabase;

import com.kyle.component.kdb.condition.ORMMapper;
import com.kyle.component.kdb.core.BaseEntity;
import com.kyle.component.kdb.error.DBException;
import com.kyle.component.kdb.interfaces.IDBListener;

import java.util.List;
import java.util.Map;

/**
 * Created by Kyle on 2020/12/22.
 */

public interface KDbManager<T extends BaseEntity> {
    SQLiteDatabase getDatabase() throws DBException;

    DAOConfig getDAOConfig();

    boolean isDatabaseExists(String dbName);

    boolean deleteDatabase(String dbName);

    String getDatabaseFullName(String dbName);

    void save(T entity) throws DBException;

    void saveAll(List<T> entityList) throws DBException;

    List<T> findAll(Class<T> entity) throws DBException;

    List<T> find(Class<T> entity, String condition) throws DBException;

    List<T> find(Class<T> entity, ORMMapper mapper) throws DBException;

    T findFirst(Class<T> entity, String condition) throws DBException;

    T findFirst(Class<T> entity, ORMMapper mapper) throws DBException;

    void delete(T entity) throws DBException;

    void delete(T[] entity) throws DBException;

    void delete(Class<T> clazz, String condition) throws DBException;

    void delete(Class<T> clazz, ORMMapper mapper) throws DBException;

    void deleteAll(Class<T> clazz) throws DBException;

    void update(T entity) throws DBException;

    void update(T entity, String condition) throws DBException;

    void update(T entity, ORMMapper mapper) throws DBException;

    void update(T entity, String condition, String name, String value) throws DBException;

    void update(T entity, String condition, String name, int value) throws DBException;

    int update(T entity, String condition, Map<String, Object> params) throws DBException;

    int update(T entity, ORMMapper mapper, Map<String, Object> params) throws DBException;

    int update(Class<T> clazz, String condition, Map<String, Object> params) throws DBException;

    int update(Class<T> clazz, ORMMapper mapper, Map<String, Object> params) throws DBException;

    void updateOrSave(T entity, String condition) throws DBException;

    void updateOrSave(T entity, ORMMapper mapper) throws DBException;

    long getCount(Class<T> clazz) throws DBException;

    void closeDb() throws DBException;

    class DAOConfig {
        private String dbName = "KApp.db";
        private int dbVersion = 1;
        IDBListener idbListener;

        public DAOConfig() {

        }

        public DAOConfig(String dbName, int dbVersion) {
            setDbName(dbName);
            setDbVersion(dbVersion);
        }

        public DAOConfig setDbName(String dbName) {
            this.dbName = dbName;
            return this;
        }

        public DAOConfig setDbVersion(int dbVersion) {
            this.dbVersion = dbVersion;
            return this;
        }

        public int getDbVersion() {
            return dbVersion;
        }

        public String getDbName() {
            return dbName;
        }

        public void setIdbListener(IDBListener<? extends BaseEntity> idbListener) {
            this.idbListener = idbListener;
        }

        public IDBListener getIdbListener() {
            return idbListener;
        }
    }
}
