package com.kyle.component.kdb.interfaces;

import android.database.sqlite.SQLiteDatabase;

import com.kyle.component.kdb.core.BaseEntity;
import com.kyle.component.kdb.error.DBException;

import java.util.List;
import java.util.Map;

/**
 * Created by Kyle on 2020/12/22.
 */

public interface IDAO<T extends BaseEntity> {

    /**
     * 获取数据库对象
     *
     * @return
     */
    SQLiteDatabase getDatabase() throws DBException;

    /**
     * 创建表
     */
    void createTable(Class clazz) throws DBException;


    /**
     * 更新实体对象
     *
     * @param entity
     */
    void update(T entity) throws DBException;

    void update(T entity, String condition) throws DBException;

    void update(T entity, String condition, String name, String value) throws DBException;

    void update(T entity, String condition, String name, int value) throws DBException;

    int update(T entity, String condition, Map<String, Object> paramsMap) throws DBException;

    void updateOrSave(T entity, String condition) throws DBException;

    /**
     * 查找所有数据
     *
     * @return
     */
    List<T> findAll(Class<T> clazz) throws DBException;

    List<T> find(Class<T> clazz, String condition) throws DBException;

    T findFirst(Class<T> clazz, String condition) throws DBException;

    /**
     * 删除所有数据
     */
    void deleteAll(Class<T> clazz) throws DBException;

    void delete(T t) throws DBException;

    void delete(T[] ts) throws DBException;

    void delete(Class<T> clazz, String condition) throws DBException;

    boolean isTableExist(String tableName) throws DBException;

    void save(T entity) throws DBException;

    void saveAll(List<T> entityList) throws DBException;

    long getCount(Class<T> clazz) throws DBException;

    void dropDb() throws DBException;

    void closeDb() throws DBException;
}
