package com.kyle.component.kdb.error;


import androidx.annotation.StringDef;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

/**
 * Created by Kyle on 2020/12/22.
 */

@StringDef({
        DBError.ERR_INVALID_ID,
        DBError.ERR_GET_COUNT,
        DBError.ERR_IS_TABLE_EXISTS,
        DBError.ERR_CREATE_TABLE,
        DBError.ERR_DROP_TABLE,
        DBError.ERR_SAVE_PARAM,
        DBError.ERR_DEL_PARAM,
        DBError.ERR_GET_PRIMARY_KEY,
        DBError.ERR_DEL,
        DBError.ERR_UPDATE_PARAM,
        DBError.ERR_GET_PRIMARY_KEY_VALUE,
        DBError.ERR_UPDATE,
        DBError.ERR_FIND_CONDITION,
        DBError.ERR_FIND
})

@Retention(RetentionPolicy.SOURCE)
public  @interface DBError {
    String ERR_INVALID_ID = "invalid entity id";

    String ERR_GET_COUNT = "execute query error during get count operation";

    String ERR_IS_TABLE_EXISTS = "check table exists error";

    String ERR_CREATE_TABLE = "create table execute SQL error";

    String ERR_DROP_TABLE = "drop table execute SQL error";

    String ERR_SAVE_PARAM = "param error during save operation";

    String ERR_DEL_PARAM = "param error during del operation";

    String ERR_GET_PRIMARY_KEY = "get PK(Primary Key) field error";

    String ERR_GET_PRIMARY_KEY_VALUE = "get PK(Primary Key) value error";

    String ERR_DEL = "execute SQL error during delete operation";

    String ERR_UPDATE_PARAM = "param error during update operation";

    String ERR_UPDATE = "execute SQL error during update operation";

    String ERR_FIND_CONDITION = "condition can not be null";

    String ERR_FIND = "execute SQL error during find operation";
}
