package com.kyle.component.kdb.core;

import com.kyle.component.kdb.annotation.AutoIncrement;
import com.kyle.component.kdb.annotation.Column;
import com.kyle.component.kdb.annotation.Id;
import com.kyle.component.kdb.annotation.Unique;

import java.lang.reflect.Field;

/**
 * Created by Kyle on 2020/12/22.
 */

public class ORMUtils {

    /**
     * 根据映射类名获取数据库创建语句
     *
     * @param clazz
     * @return
     */
    public static String genCreateTableSQL(Class clazz) {
        boolean isHaveKeyId = false;
        boolean isHaveColumnAnnotation = false;
        String strIdName = null;
        StringBuilder createSb = new StringBuilder("CREATE TABLE IF NOT EXISTS ");
        StringBuilder sbUnique = new StringBuilder("");
        String tableName = ORMMethodUtils.getTableName(clazz);
        createSb.append(tableName);
        createSb.append(" ( ");
        Field[] fields = ORMMethodUtils.getDeclaredField(clazz);
        //查找对应的主键
        for (Field field : fields) {
            if (field.isAnnotationPresent(Id.class)) {

                //如果已经有主键了，直接开始下一个
                if (isHaveKeyId)
                    continue;
                String idName = strIdName = ORMMethodUtils.getColumnName(field);
                createSb.append(idName);
                createSb.append(" ");
                createSb.append(fieldType2DBType(field.getGenericType().toString()));
                createSb.append(" NOT NULL PRIMARY KEY ");
                // 是否自增长
                if (field.isAnnotationPresent(AutoIncrement.class)
                        && (field.getGenericType().toString().equals("class java.lang.Integer") || field
                        .getGenericType().toString().equals("int"))) {
                    createSb.append("AUTOINCREMENT");
                }
                createSb.append(", ");
                isHaveKeyId = true;
            } else if (field.isAnnotationPresent(Column.class)) {
                String colName = ORMMethodUtils.getColumnName(field);
                createSb.append(colName);
                createSb.append(" ");
                createSb.append(fieldType2DBType(field.getGenericType().toString()));
                createSb.append(", ");
                if (field.isAnnotationPresent(Unique.class)) {
                    sbUnique.append("CONSTRAINT \"u" + colName.toLowerCase() + "\" UNIQUE (\"" + colName + "\"),");
                }
            }
        }

        // 没有任何数据库映射关系
        if (!isHaveColumnAnnotation && !isHaveKeyId) {
            return null;
        }

        createSb.append("CONSTRAINT \"u" + strIdName.toLowerCase() + "\" UNIQUE (\"" + strIdName + "\")");
        if (sbUnique.length() > 0) {
            createSb.append(",");
            createSb.append(sbUnique.deleteCharAt(sbUnique.length() - 1));
        }
        createSb.append(" )");
        return createSb.toString();
    }

    /**
     * 将JAVA类型转换为数据库类型
     *
     * @param fieldGenericTyp
     * @return
     */
    private static String fieldType2DBType(String fieldGenericTyp) {
        if (fieldGenericTyp.equals("class java.lang.String")) {
            return "VARCHAR";
        } else if (fieldGenericTyp.equals("class java.lang.Boolean") || fieldGenericTyp.equals("boolean")
                || fieldGenericTyp.equals("class java.lang.Integer") || fieldGenericTyp.equals("int")
                || fieldGenericTyp.equals("class java.lang.Long") || fieldGenericTyp.equals("long")
                || fieldGenericTyp.equals("class java.lang.Short") || fieldGenericTyp.equals("short")
                || fieldGenericTyp.equals("class java.lang.Byte") || fieldGenericTyp.equals("byte")) {
            return "INTEGER";
        } else if (fieldGenericTyp.equals("class [B")) {
            return "BLOB";
        } else if (fieldGenericTyp.equals("class java.lang.Float") || fieldGenericTyp.equals("float")) {
            return "float";
        } else if (fieldGenericTyp.equals("class java.lang.Double") || fieldGenericTyp.equals("double")) {
            return "double";
        }
        return null;
    }

}
