package com.kyle.component.kdb.core;


import com.kyle.component.kdb.annotation.AutoIncrement;
import com.kyle.component.kdb.annotation.Id;
import com.kyle.component.kdb.annotation.Unique;
import com.kyle.component.kdb.error.DBError;
import com.kyle.component.kdb.error.DBException;

/**
 * Created by Kyle on 2020/12/22.
 * <p>实体基类</p>
 * <p>每一个表都应当有一个唯一的ID</p>
 */

public abstract class BaseEntity {

    @Id
    @AutoIncrement
    @Unique
    private Integer id; // 通过 @Id 与 @AutoIncrement 注解标识为自增长id

    public Integer getIncrementId() {
        return id;
    }

    public void setIncrementId(Integer id) throws DBException {
        if (id < 1) {
            throw new DBException(DBError.ERR_INVALID_ID);
        }
        this.id = id;
    }

}
