package com.kyle.component.kdb;

import android.content.Context;

import com.kyle.component.kdb.impl.KDbManagerImpl;
import com.kyle.component.kdb.manager.KDbManager;

/**
 * Created by Kyle on 2020/12/22.
 */

public class KAppDb {
    private static KAppDb kAppDb;
    private Context context;
    private KDbManager.DAOConfig defaultConfig;

    private KAppDb() {

    }

    public static KAppDb getAppDb() {
        if (kAppDb == null) {
            synchronized (KAppDb.class) {
                kAppDb = new KAppDb();
            }
        }
        return kAppDb;
    }

    public synchronized void init(Context context) {
        if (this.context == null)
            this.context = context;
    }

    public synchronized void init(Context context, String dbName, int dbVersion) {
        if (this.context == null)
            this.context = context;
        defaultConfig = new KDbManager.DAOConfig(dbName, dbVersion);
    }

    public Context getContext() {
        return context;
    }

    public KDbManager getFBSDbManager(KDbManager.DAOConfig daoConfig) {
        return KDbManagerImpl.getInstance(daoConfig);
    }

    public synchronized KDbManager getFBSDbManager() {
        return KDbManagerImpl.getInstance(defaultConfig);
    }


}
