/*
 * Decompiled with CFR 0.152.
 */
package cn.zkdcloud.util;

import cn.zkdcloud.util.AssertUtil;
import com.thoughtworks.xstream.XStream;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class StreamUtil {
    private static Logger logger = Logger.getLogger(StreamUtil.class);
    private static XStream xStream = new XStream();

    public static String xmlToJson(HttpServletRequest request) {
        ServletInputStream inputStream = null;
        SAXReader reader = new SAXReader();
        Document doc = null;
        StringBuffer jsonBuffer = new StringBuffer("");
        try {
            inputStream = request.getInputStream();
            doc = reader.read((InputStream)inputStream);
            Element root = doc.getRootElement();
            jsonBuffer.append(StreamUtil.getElementValue(root));
            inputStream.close();
            return jsonBuffer.toString();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return "";
    }

    public static String getElementValue(Element element) {
        List childElements = element.elements();
        if (AssertUtil.isNullOrEmpty((Collection)childElements)) {
            return "\"" + element.getText() + "\"";
        }
        StringBuffer jsonBuffer = new StringBuffer("{");
        Iterator iterator = childElements.iterator();
        while (iterator.hasNext()) {
            Element e = (Element)iterator.next();
            jsonBuffer.append("\"" + e.getName() + "\" : ");
            jsonBuffer.append(StreamUtil.getElementValue(e));
            if (!iterator.hasNext()) continue;
            jsonBuffer.append(",");
        }
        jsonBuffer.append("}");
        return jsonBuffer.toString();
    }

    public static String ObjToXml(Object object) {
        return xStream.toXML(object);
    }

    public static String inputStreamToStr(InputStream inputStream) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        StringBuffer sb = new StringBuffer("");
        try {
            String len;
            while ((len = reader.readLine()) != null) {
                sb.append(len);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    static {
        xStream.autodetectAnnotations(true);
    }
}

