/*
 * Decompiled with CFR 0.152.
 */
package cn.zkdcloud.util;

import cn.zkdcloud.util.Const;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

public class HttpUtil {
    private static Logger logger = Logger.getLogger(HttpUtil.class);
    public static HttpClient httpClient = HttpClients.createDefault();

    public static String doGet(String url) {
        return HttpUtil.httpExecute((HttpUriRequest)new HttpGet(url));
    }

    public static File doGet(String url, String filePath) {
        HttpGet httpGet = new HttpGet(url);
        return HttpUtil.httpExecute((HttpUriRequest)httpGet, filePath);
    }

    public static String doPost(String url) {
        HttpPost httpPost = new HttpPost(url);
        return HttpUtil.httpExecute((HttpUriRequest)httpPost);
    }

    public static String doPost(String url, String data) {
        HttpPost httpPost = new HttpPost(url);
        httpPost.setEntity((HttpEntity)new StringEntity(data, "UTF-8"));
        return HttpUtil.httpExecute((HttpUriRequest)httpPost);
    }

    public static String doPost(String url, File file) {
        HttpPost httpPost = new HttpPost(url);
        FileBody body = new FileBody(file);
        HttpEntity fileEntity = MultipartEntityBuilder.create().addPart("media", (ContentBody)body).build();
        httpPost.setEntity(fileEntity);
        return HttpUtil.httpExecute((HttpUriRequest)httpPost);
    }

    public static String doPost(String url, File file, String attach) {
        HttpPost httpPost = new HttpPost(url);
        FileBody body = new FileBody(file);
        MultipartEntityBuilder builder = MultipartEntityBuilder.create().addPart("media", (ContentBody)body);
        JSONObject attachParams = JSONObject.parseObject((String)attach);
        for (String key : attachParams.keySet()) {
            builder.addTextBody(key, attachParams.getString(key));
        }
        httpPost.setEntity(builder.build());
        return HttpUtil.httpExecute((HttpUriRequest)httpPost);
    }

    public static String doPost(String url, InputStream inputStream, String fileName) {
        HttpPost httpPost = new HttpPost(url);
        InputStreamBody body = new InputStreamBody(inputStream, fileName);
        HttpEntity fileEntity = MultipartEntityBuilder.create().addPart("media", (ContentBody)body).build();
        httpPost.setEntity(fileEntity);
        return HttpUtil.httpExecute((HttpUriRequest)httpPost);
    }

    public static String httpExecute(HttpUriRequest http) {
        try {
            HttpResponse response = httpClient.execute(http);
            return EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
        }
        catch (IOException e) {
            e.printStackTrace();
            return Const.HTTP_ERROR;
        }
    }

    public static File httpExecute(HttpUriRequest http, String filePath) {
        File downloadFile = new File(filePath);
        try {
            if (!downloadFile.isDirectory() && !downloadFile.exists()) {
                downloadFile.createNewFile();
            }
            if (downloadFile.canWrite()) {
                HttpResponse response = httpClient.execute(http);
                response.getEntity().writeTo((OutputStream)new FileOutputStream(downloadFile));
            }
            return downloadFile;
        }
        catch (IOException e) {
            logger.info((Object)("filePath is error:" + e.getMessage()));
            return null;
        }
    }
}

