/*
 * Decompiled with CFR 0.152.
 */
package cn.zkdcloud.core;

import cn.zkdcloud.core.Component;
import cn.zkdcloud.core.MenuComponent;
import cn.zkdcloud.core.MessageComponent;
import cn.zkdcloud.core.Oauth2AuthorizeComponent;
import cn.zkdcloud.core.TemplateComponent;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class WeChat {
    private static Logger logger = Logger.getLogger(WeChat.class);
    private static WeChat weChat;
    private static List<Component> components;

    private WeChat() {
    }

    public void start() {
        try {
            for (Component component : components) {
                component.init();
            }
            logger.info((Object)"init weChat success");
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)("init weChat fail:" + e.getMessage()));
        }
    }

    public void startDefault() {
        this.addComponent(MessageComponent.class);
        this.addComponent(MenuComponent.class);
        this.addComponent(TemplateComponent.class);
        this.addComponent(Oauth2AuthorizeComponent.class);
        this.start();
    }

    public WeChat addComponent(Class<? extends Component> componentClass) {
        try {
            Method getInstance = componentClass.getDeclaredMethod("getInstance", new Class[0]);
            components.add((Component)getInstance.invoke(null, new Object[0]));
            logger.info((Object)("add component : " + componentClass));
        }
        catch (Exception e) {
            logger.info((Object)("add" + componentClass + "fail"));
        }
        return this;
    }

    public static WeChat getInstance() {
        if (null == weChat) {
            weChat = new WeChat();
        }
        return weChat;
    }

    static {
        components = new ArrayList<Component>();
    }
}

