/*
 * Decompiled with CFR 0.152.
 */
package cn.zkdcloud.core;

import cn.zkdcloud.core.Component;
import cn.zkdcloud.exception.WeChatException;
import cn.zkdcloud.util.AccessToken;
import cn.zkdcloud.util.HttpUtil;
import cn.zkdcloud.util.JsonUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import org.apache.log4j.Logger;

public class UserTagComponent
implements Component {
    private static Logger logger = Logger.getLogger(UserTagComponent.class);
    public static UserTagComponent userTagComponent;
    public static String CREATE_TAG_URL;
    public static String GET_TAG_URL;
    public static String UPDATE_TAG_URL;
    public static String DELETE_TAG_URL;
    public static String GET_TAG_USERS;
    public static String BATCH_TAG_URL;
    public static String BATCH_UNTAG_URL;
    public static String GET_TAGS_BY_USER;

    @Override
    public void init() {
    }

    private UserTagComponent() {
    }

    public String createTag(String tagName) throws WeChatException {
        String ret = HttpUtil.doPost(CREATE_TAG_URL, "{\"tag\" : {\"name\" : \"" + tagName + "\"}}");
        if (JsonUtil.isError(ret)) {
            throw new WeChatException("create tag fail:" + ret);
        }
        return ret;
    }

    public JSONArray getTags() {
        String ret = HttpUtil.doGet(GET_TAG_URL);
        if (JsonUtil.isError(ret)) {
            logger.info((Object)("get tags list fail :" + ret));
            return null;
        }
        return JSONObject.parseObject((String)ret).getJSONArray("tags");
    }

    public boolean updateTag(Integer id, String tagName) {
        String ret = HttpUtil.doPost(UPDATE_TAG_URL, " {\"tag\" : {\"id\" : " + id + ", \"name\" : \"" + tagName + "\"}}");
        if (JsonUtil.isError(ret)) {
            logger.info((Object)("update tag name " + tagName + " fail :" + ret));
            return false;
        }
        return true;
    }

    public boolean deleteTag(Integer id) {
        String ret = HttpUtil.doPost(DELETE_TAG_URL, "{\"tag\":{\"id\" : " + id + "}}");
        if (JsonUtil.isError(ret)) {
            logger.info((Object)("delete tag id " + id + " fail:" + ret));
            return false;
        }
        return true;
    }

    public List<String> getUserByTagId(Integer tagid) {
        return this.getUserByTagId(tagid, null);
    }

    public List<String> getUserByTagId(Integer tagid, String next_openid) {
        JSONObject data = new JSONObject();
        data.put("tagid", (Object)tagid);
        data.put("next_openid", (Object)next_openid);
        String ret = HttpUtil.doPost(GET_TAG_USERS, data.toJSONString());
        if (JsonUtil.isError(ret)) {
            logger.info((Object)("get users by tagid fail:" + ret));
            return null;
        }
        JSONObject retJson = JSONObject.parseObject((String)ret);
        if (null != retJson.get((Object)"data")) {
            return retJson.getJSONObject("data").getJSONArray("openid").toJavaList(String.class);
        }
        return null;
    }

    public boolean batchTags(List<String> openid_list, Integer tagid) {
        JSONObject data = new JSONObject();
        data.put("tagid", (Object)tagid);
        data.put("openid_list", openid_list);
        String ret = HttpUtil.doPost(BATCH_TAG_URL, data.toJSONString());
        if (JsonUtil.isError(ret)) {
            logger.info((Object)"batch users to tag error");
            return false;
        }
        return true;
    }

    public boolean batchUnTags(List<String> openid_list, Integer tagid) {
        JSONObject data = new JSONObject();
        data.put("tagid", (Object)tagid);
        data.put("openid_list", openid_list);
        String ret = HttpUtil.doPost(BATCH_UNTAG_URL, data.toJSONString());
        if (JsonUtil.isError(ret)) {
            logger.info((Object)"batch users to untag error");
            return false;
        }
        return true;
    }

    public List<Integer> getTagsByUser(String open_id) {
        String ret = HttpUtil.doPost(GET_TAGS_BY_USER, "{\"openid\" : \"" + open_id + "\"}");
        if (JsonUtil.isError(ret)) {
            logger.info((Object)("get tags by user fail" + ret));
            return null;
        }
        if (null != JSONObject.parseObject((String)ret).get((Object)"tagid_list")) {
            return JSONObject.parseObject((String)ret).getJSONArray("tagid_list").toJavaList(Integer.class);
        }
        return null;
    }

    public static UserTagComponent getInstance() {
        if (null == userTagComponent) {
            userTagComponent = new UserTagComponent();
        }
        return userTagComponent;
    }

    static {
        CREATE_TAG_URL = "https://api.weixin.qq.com/cgi-bin/tags/create?access_token=" + AccessToken.getAccessToken();
        GET_TAG_URL = "https://api.weixin.qq.com/cgi-bin/tags/get?access_token=" + AccessToken.getAccessToken();
        UPDATE_TAG_URL = "https://api.weixin.qq.com/cgi-bin/tags/update?access_token=" + AccessToken.getAccessToken();
        DELETE_TAG_URL = "https://api.weixin.qq.com/cgi-bin/tags/delete?access_token=" + AccessToken.getAccessToken();
        GET_TAG_USERS = "https://api.weixin.qq.com/cgi-bin/user/tag/get?access_token=" + AccessToken.getAccessToken();
        BATCH_TAG_URL = "https://api.weixin.qq.com/cgi-bin/tags/members/batchtagging?access_token=" + AccessToken.getAccessToken();
        BATCH_UNTAG_URL = "https://api.weixin.qq.com/cgi-bin/tags/members/batchuntagging?access_token=" + AccessToken.getAccessToken();
        GET_TAGS_BY_USER = "https://api.weixin.qq.com/cgi-bin/tags/getidlist?access_token=" + AccessToken.getAccessToken();
    }
}

