/*
 * Decompiled with CFR 0.152.
 */
package cn.zkdcloud.core;

import cn.zkdcloud.component.user.UserInfo;
import cn.zkdcloud.core.Component;
import cn.zkdcloud.util.AccessToken;
import cn.zkdcloud.util.HttpUtil;
import cn.zkdcloud.util.JsonUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import org.apache.log4j.Logger;

public class UserManagerComponent
implements Component {
    private static Logger logger = Logger.getLogger(UserManagerComponent.class);
    public static UserManagerComponent userManagerComponent;
    public static String USER_REMARK_URL;
    public static String GET_USER_INFO;
    public static String BATCH_GET_USERINFOS;
    public static String GET_USER_OPENIDS;
    public static String GET_BLACK_LIST;
    public static String BATCH_BLACK_USES;
    public static String BARCH_UNBLACK_USERS;

    @Override
    public void init() {
    }

    private UserManagerComponent() {
    }

    public boolean remarkUser(String openid, String remarkName) {
        JSONObject data = new JSONObject();
        data.put("openid", (Object)openid);
        data.put("remark", (Object)remarkName);
        String ret = HttpUtil.doPost(USER_REMARK_URL, data.toJSONString());
        if (JsonUtil.isError(ret)) {
            logger.info((Object)("remark user:" + openid + remarkName + " fail"));
            return false;
        }
        return true;
    }

    public UserInfo getUserInfoByOpenId(String openid) {
        return this.getUserInfoByOpenId(openid, "zh_CN");
    }

    public UserInfo getUserInfoByOpenId(String openid, String lang) {
        String ret = HttpUtil.doPost(GET_USER_INFO + "&openid=" + openid + "&lang=" + lang);
        if (JsonUtil.isError(ret)) {
            logger.info((Object)("get userInfo :" + openid + "fail"));
            return null;
        }
        return (UserInfo)JSONObject.parseObject((String)ret).toJavaObject(UserInfo.class);
    }

    public List<UserInfo> getBatchUserInfo(List<String> openids) {
        return this.getBatchUserInfo(openids, "zh_CN");
    }

    public List<UserInfo> getBatchUserInfo(List<String> openids, String lang) {
        JSONObject data = new JSONObject();
        JSONArray userList = new JSONArray();
        for (String openid : openids) {
            userList.add((Object)("{\"openid\": \"" + openid + "\",\"lang\": \"" + lang + "\"}"));
        }
        data.put("user_list", (Object)userList);
        String ret = HttpUtil.doPost(BATCH_GET_USERINFOS, data.toJSONString());
        if (JsonUtil.isError(ret)) {
            logger.info((Object)("get batch uerInfo fail:" + ret));
            return null;
        }
        if (null != JSONObject.parseObject((String)ret).getJSONArray("user_info_list")) {
            return JSONObject.parseObject((String)ret).getJSONArray("user_info_list").toJavaList(UserInfo.class);
        }
        return null;
    }

    public List<String> getUserOpenids() {
        return this.getUserOpenids(null);
    }

    public List<String> getUserOpenids(String next_openid) {
        String ret = null != next_openid ? HttpUtil.doGet(GET_USER_OPENIDS + "&next_openid=" + next_openid) : HttpUtil.doGet(GET_USER_OPENIDS);
        if (JsonUtil.isError(ret)) {
            logger.info((Object)("get user openids fail" + ret));
            return null;
        }
        if (null != JSONObject.parseObject((String)ret).getJSONObject("data")) {
            return JSONObject.parseObject((String)ret).getJSONObject("data").getJSONArray("openid").toJavaList(String.class);
        }
        return null;
    }

    public List<String> getBlackList() {
        return this.getBlackList(null);
    }

    public List<String> getBlackList(String begin_openid) {
        String ret = null == begin_openid ? HttpUtil.doPost(GET_BLACK_LIST) : HttpUtil.doPost(GET_BLACK_LIST, "{\"begin_openid\":\"" + begin_openid + "\"}");
        if (JsonUtil.isError(ret) || null == JSONObject.parseObject((String)ret).get((Object)"data")) {
            logger.info((Object)("get blackList fail or list is not :" + ret));
            return null;
        }
        return JSONObject.parseObject((String)ret).getJSONObject("data").getJSONArray("openid").toJavaList(String.class);
    }

    public boolean batchBlackUsers(List<String> openIds) {
        JSONObject data = new JSONObject();
        data.put("opened_list", openIds);
        String ret = HttpUtil.doPost(BATCH_BLACK_USES, data.toJSONString());
        if (JsonUtil.isError(ret)) {
            logger.info((Object)("batch black users fail :" + ret));
            return false;
        }
        return true;
    }

    public boolean batchUnblackUsers(List<String> openIds) {
        JSONObject data = new JSONObject();
        data.put("opened_list", openIds);
        String ret = HttpUtil.doPost(BARCH_UNBLACK_USERS, data.toJSONString());
        if (JsonUtil.isError(ret)) {
            logger.info((Object)("batch unblack users fail :" + ret));
            return false;
        }
        return true;
    }

    public static UserManagerComponent getInstance() {
        if (null == userManagerComponent) {
            userManagerComponent = new UserManagerComponent();
        }
        return userManagerComponent;
    }

    static {
        USER_REMARK_URL = "https://api.weixin.qq.com/cgi-bin/user/info/updateremark?access_token=" + AccessToken.getAccessToken();
        GET_USER_INFO = "https://api.weixin.qq.com/cgi-bin/user/info?access_token=" + AccessToken.getAccessToken();
        BATCH_GET_USERINFOS = "https://api.weixin.qq.com/cgi-bin/user/info/batchget?access_token=" + AccessToken.getAccessToken();
        GET_USER_OPENIDS = "https://api.weixin.qq.com/cgi-bin/user/get?access_token=" + AccessToken.getAccessToken();
        GET_BLACK_LIST = "https://api.weixin.qq.com/cgi-bin/tags/members/getblacklist?access_token=" + AccessToken.getAccessToken();
        BATCH_BLACK_USES = "https://api.weixin.qq.com/cgi-bin/tags/members/batchblacklist?access_token=" + AccessToken.getAccessToken();
        BARCH_UNBLACK_USERS = "https://api.weixin.qq.com/cgi-bin/tags/members/batchunblacklist?access_token=" + AccessToken.getAccessToken();
    }
}

