/*
 * Decompiled with CFR 0.152.
 */
package cn.zkdcloud.core;

import cn.zkdcloud.core.Component;
import cn.zkdcloud.util.AccessToken;
import cn.zkdcloud.util.HttpUtil;
import cn.zkdcloud.util.JsonUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class TemplateComponent
implements Component {
    private static Logger logger = Logger.getLogger(TemplateComponent.class);
    public static TemplateComponent templateComponent;
    private List<TemplateMessage> templateList;
    public static String SET_INDUSTRY;
    public static String GET_INDUSTRY;
    public static String GET_TEMPLATE_ID;
    public static String GET_ALL_TEMPLATE;
    public static String SEND_TEMPLATE_MESSAGE;
    public static String DELETE_TEMPLATE_MESSAGE;

    @Override
    public void init() {
        this.getListTemplateMessage(true);
    }

    private TemplateComponent() {
    }

    public void setTemplateIndustry(Integer industry_id1, Integer industry_id2) {
        JSONObject industry = new JSONObject();
        industry.put("industry_id1", (Object)String.valueOf(industry_id1));
        industry.put("industry_id2", (Object)String.valueOf(industry_id2));
        String ret = HttpUtil.doPost(SET_INDUSTRY, industry.toJSONString());
        if (JsonUtil.isError(ret)) {
            logger.info((Object)"set industry is error");
            return;
        }
        logger.info((Object)"set industry success");
    }

    public String getAllIndustry() {
        return HttpUtil.doGet(GET_INDUSTRY);
    }

    public List<TemplateMessage> getListTemplateMessage(boolean refresh) {
        if (refresh) {
            String ret = HttpUtil.doGet(GET_ALL_TEMPLATE);
            if (null == this.templateList) {
                this.templateList = new ArrayList<TemplateMessage>();
            }
            this.templateList = JSON.parseArray((String)JSONObject.parseObject((String)ret).getString("template_list"), TemplateMessage.class);
            logger.info((Object)"init get templateList success");
        }
        return this.templateList;
    }

    public List<TemplateMessage> getListTemplateMessage() {
        return this.getListTemplateMessage(false);
    }

    public TemplateMessage getTemplateByName(String name) {
        TemplateMessage templateMessage = this.getLocalTemplateByName(name);
        if (null == templateMessage) {
            this.getListTemplateMessage(true);
            templateMessage = this.getLocalTemplateByName(name);
        }
        return templateMessage;
    }

    public TemplateMessage getLocalTemplateByName(String name) {
        if (null != this.templateList) {
            for (TemplateMessage template : this.templateList) {
                if (!template.getTitle().equals(name)) continue;
                return template;
            }
        }
        return null;
    }

    public String getTemplateId(String template_id_short) {
        String ret = HttpUtil.doPost(GET_TEMPLATE_ID, template_id_short);
        if (!JsonUtil.isError(ret)) {
            return JSONObject.parseObject((String)ret).getString("template_id");
        }
        return null;
    }

    public void sendTemplateMessage(TemplateMessage templateMessage) {
        String ret = HttpUtil.doPost(SEND_TEMPLATE_MESSAGE, JSON.toJSONString((Object)templateMessage));
        if (JsonUtil.isError(ret)) {
            logger.info((Object)("send " + templateMessage.getTemplate_id() + " template message to" + templateMessage.getTouser() + "is fail"));
        }
        logger.info((Object)"send template success");
    }

    public void deleteTemplateMessageByName(String name) {
        TemplateMessage template = this.getTemplateByName(name);
        if (null != template) {
            this.deleteTemplateMessageById(template.getTemplate_id());
            return;
        }
    }

    public void deleteTemplateMessageById(String template_id) {
        JSONObject data = new JSONObject();
        data.put("template_id", (Object)template_id);
        String ret = HttpUtil.doPost(DELETE_TEMPLATE_MESSAGE, data.toJSONString());
        if (JsonUtil.isError(ret)) {
            logger.info((Object)"delete template message fail");
            return;
        }
        logger.info((Object)"delete template message success");
    }

    public static TemplateComponent getInstance() {
        if (null == templateComponent) {
            templateComponent = new TemplateComponent();
        }
        return templateComponent;
    }

    static {
        SET_INDUSTRY = "https://api.weixin.qq.com/cgi-bin/template/api_set_industry?access_token=" + AccessToken.getAccessToken();
        GET_INDUSTRY = "https://api.weixin.qq.com/cgi-bin/template/get_industry?access_token=" + AccessToken.getAccessToken();
        GET_TEMPLATE_ID = "https://api.weixin.qq.com/cgi-bin/template/api_add_template?access_token=" + AccessToken.getAccessToken();
        GET_ALL_TEMPLATE = "https://api.weixin.qq.com/cgi-bin/template/get_all_private_template?access_token=" + AccessToken.getAccessToken();
        SEND_TEMPLATE_MESSAGE = "https://api.weixin.qq.com/cgi-bin/message/template/send?access_token=" + AccessToken.getAccessToken();
        DELETE_TEMPLATE_MESSAGE = "https://api.weixin.qq.com/cgi-bin/template/del_private_template?access_token=" + AccessToken.getAccessToken();
    }

    public static class TemplateMessage {
        private String touser;
        private String title;
        private String template_id;
        private String url;
        private String primary_industry;
        private String deputy_industry;
        private String content;
        private String example;
        private JSONObject miniprogram;
        private JSONObject data;

        private TemplateMessage() {
        }

        public TemplateMessage(String touser, String template_id, String url) {
            this.touser = touser;
            this.template_id = template_id;
            this.url = url;
        }

        public void setTouserAndUrl(String touser, String url) {
            this.touser = touser;
            this.url = url;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getPrimary_industry() {
            return this.primary_industry;
        }

        public void setPrimary_industry(String primary_industry) {
            this.primary_industry = primary_industry;
        }

        public String getDeputy_industry() {
            return this.deputy_industry;
        }

        public void setDeputy_industry(String deputy_industry) {
            this.deputy_industry = deputy_industry;
        }

        public String getContent() {
            return this.content;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public String getExample() {
            return this.example;
        }

        public void setExample(String example) {
            this.example = example;
        }

        public void setMiniprogram(JSONObject miniprogram) {
            this.miniprogram = miniprogram;
        }

        public String getTouser() {
            return this.touser;
        }

        public void setTouser(String touser) {
            this.touser = touser;
        }

        public String getTemplate_id() {
            return this.template_id;
        }

        public void setTemplate_id(String template_id) {
            this.template_id = template_id;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public JSONObject getMiniprogram() {
            return this.miniprogram;
        }

        public void setMiniprogram(String appid, String pagepath) {
            JSONObject mini = new JSONObject();
            mini.put("appid", (Object)appid);
            mini.put("pagepath", (Object)pagepath);
            this.miniprogram = mini;
        }

        public JSONObject getData() {
            return this.data;
        }

        public void setData(JSONObject data) {
            this.data = data;
        }

        public TemplateMessage addData(String dataName, String value, String color) {
            if (this.data == null) {
                this.data = new JSONObject();
            }
            JSONObject dataOne = new JSONObject();
            dataOne.put("value", (Object)value);
            dataOne.put("color", (Object)color);
            this.data.put(dataName, (Object)dataOne);
            return this;
        }

        public TemplateMessage addData(String dataName, String value) {
            return this.addData(dataName, value, "#000");
        }
    }
}

