/*
 * Decompiled with CFR 0.152.
 */
package cn.zkdcloud.core;

import cn.zkdcloud.component.qrcode.QrType;
import cn.zkdcloud.core.Component;
import cn.zkdcloud.util.AccessToken;
import cn.zkdcloud.util.HttpUtil;
import cn.zkdcloud.util.JsonUtil;
import com.alibaba.fastjson.JSONObject;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.log4j.Logger;

public class QrcodeComponent
implements Component {
    private static Logger logger = Logger.getLogger(QrcodeComponent.class);
    public static QrcodeComponent qrcodeComponent;
    public static String CREATE_QR;
    public static String GET_GR;

    @Override
    public void init() {
    }

    public String createIntegerQr(Integer scene_id, QrType type) {
        String ret;
        JSONObject data = new JSONObject();
        JSONObject action_info = new JSONObject();
        JSONObject scene = new JSONObject();
        scene.put("scene_id", (Object)scene_id);
        action_info.put("scene", (Object)scene);
        data.put("action_info", (Object)action_info);
        if (QrType.QR_SCENE == type) {
            data.put("expire_seconds", (Object)2592000);
            data.put("action_name", (Object)QrType.QR_SCENE.toString());
            ret = HttpUtil.doPost(CREATE_QR, data.toJSONString());
        } else if (QrType.QR_LIMIT_SCENE == QrType.QR_LIMIT_SCENE) {
            data.put("action_name", (Object)QrType.QR_LIMIT_SCENE.toString());
            ret = HttpUtil.doPost(CREATE_QR, data.toJSONString());
        } else {
            logger.info((Object)"qr type is not support");
            return null;
        }
        if (JsonUtil.isError(ret)) {
            logger.info((Object)"get Integer qr fail");
            return null;
        }
        try {
            return GET_GR + URLEncoder.encode(JSONObject.parseObject((String)ret).getString("ticket"), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.info((Object)("get qrcode fail" + e.getMessage()));
            return null;
        }
    }

    public String createStrQr(String scene_str, QrType type) {
        String ret;
        JSONObject data = new JSONObject();
        JSONObject action_info = new JSONObject();
        JSONObject scene = new JSONObject();
        scene.put("scene_str", (Object)scene_str);
        action_info.put("scene", (Object)scene);
        data.put("action_info", (Object)action_info);
        if (QrType.QR_STR_SCENE == type) {
            data.put("expire_seconds", (Object)2592000);
            data.put("action_name", (Object)QrType.QR_SCENE.toString());
            ret = HttpUtil.doPost(CREATE_QR, data.toJSONString());
        } else if (QrType.QR_LIMIT_STR_SCENE == QrType.QR_LIMIT_SCENE) {
            data.put("action_name", (Object)QrType.QR_LIMIT_SCENE.toString());
            ret = HttpUtil.doPost(CREATE_QR, data.toJSONString());
        } else {
            logger.info((Object)"qr type is not support");
            return null;
        }
        if (JsonUtil.isError(ret)) {
            logger.info((Object)"get str qr fail");
            return null;
        }
        try {
            return GET_GR + URLEncoder.encode(JSONObject.parseObject((String)ret).getString("ticket"), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.info((Object)("get qrcode fail" + e.getMessage()));
            return null;
        }
    }

    public static QrcodeComponent getInstance() {
        if (null == qrcodeComponent) {
            qrcodeComponent = new QrcodeComponent();
        }
        return qrcodeComponent;
    }

    static {
        CREATE_QR = "https://api.weixin.qq.com/cgi-bin/qrcode/create?access_token=" + AccessToken.getAccessToken();
        GET_GR = "https://mp.weixin.qq.com/cgi-bin/showqrcode?ticket=";
    }
}

